/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class DrawableBuffer
implements Drawable,
Measurable {
    Image image;
    boolean invalid = true;
    ArrayList drawableList = new ArrayList();
    Color background = Color.white;
    boolean measured = false;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    boolean visible = true;

    public DrawableBuffer() {
    }

    public DrawableBuffer(Drawable drawable) {
        this.addDrawable(drawable);
    }

    public synchronized void addDrawable(Drawable drawable) {
        if (!this.drawableList.contains(drawable)) {
            this.drawableList.add(drawable);
        }
        this.invalidateImage();
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public synchronized void clear() {
        this.drawableList.clear();
        this.invalidateImage();
    }

    public void invalidateImage() {
        this.measured = false;
        ArrayList arrayList = (ArrayList)this.drawableList.clone();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.ymin = Double.MAX_VALUE;
        this.ymax = -1.7976931348623157E308;
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (!(drawable instanceof Measurable) || !((Measurable)drawable).isMeasured()) continue;
            this.xmin = Math.min(this.xmin, ((Measurable)drawable).getXMin());
            this.xmax = Math.max(this.xmax, ((Measurable)drawable).getXMax());
            this.ymin = Math.min(this.ymin, ((Measurable)drawable).getYMin());
            this.ymax = Math.max(this.ymax, ((Measurable)drawable).getYMax());
            this.measured = true;
        }
        this.invalid = true;
    }

    public void updateImage(DrawingPanel drawingPanel) {
        this.invalid = false;
        Image image = this.image;
        int n = drawingPanel.getWidth();
        int n2 = drawingPanel.getHeight();
        if (this.image == null || this.image.getWidth(drawingPanel) != n || this.image.getHeight(drawingPanel) != n2) {
            image = drawingPanel.createImage(n, n2);
        }
        if (image == null) {
            return;
        }
        Graphics graphics = image.getGraphics();
        if (graphics != null) {
            if (this.background == null) {
                graphics.clearRect(0, 0, n, n2);
            } else {
                graphics.setColor(this.background);
                graphics.fillRect(0, 0, n, n2);
            }
            this.paintMyDrawableList(drawingPanel, graphics);
            graphics.dispose();
        }
        this.image = image;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.invalid || this.image == null || this.image.getWidth(drawingPanel) != drawingPanel.getWidth() || this.image.getHeight(drawingPanel) != drawingPanel.getHeight()) {
            this.updateImage(drawingPanel);
        }
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, drawingPanel);
        }
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isMeasured() {
        return this.measured;
    }

    private void paintMyDrawableList(DrawingPanel drawingPanel, Graphics graphics) {
        ArrayList arrayList = (ArrayList)this.drawableList.clone();
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            drawable.draw(drawingPanel, graphics);
        }
    }
}

