/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class DatasetManager
extends AbstractTableModel
implements Measurable {
    ArrayList datasets = new ArrayList();
    boolean connected;
    boolean sorted;
    int markerShape;
    int stride = 1;
    boolean linked = false;
    String xColumnName = "x";
    String yColumnName = "y";
    Map properties = new TreeMap();
    static /* synthetic */ Class class$java$lang$Double;

    public DatasetManager() {
        this(false, false, false, 2);
    }

    public DatasetManager(boolean bl) {
        this(false, false, bl, 2);
    }

    public DatasetManager(boolean bl, boolean bl2) {
        this(bl, bl2, false, 2);
    }

    public DatasetManager(boolean bl, boolean bl2, boolean bl3, int n) {
        this.connected = bl;
        this.sorted = bl2;
        this.markerShape = n;
        this.linked = bl3;
    }

    public void setXPointsLinked(boolean bl) {
        this.linked = bl;
        for (int i = 1; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            dataset.setXColumnVisible(!this.linked);
        }
    }

    public void setSorted(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setSorted(bl);
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setSorted(bl);
        }
    }

    public void setConnected(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setConnected(bl);
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setConnected(bl);
        }
    }

    public void setStride(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setStride(n2);
    }

    public void setStride(int n) {
        this.stride = n;
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).setStride(this.stride);
        }
    }

    public void setMarkerColor(int n, Color color) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setMarkerColor(color);
    }

    public void setMarkerColor(int n, Color color, Color color2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setMarkerColor(color, color2);
    }

    public void setMarkerShape(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setMarkerShape(n2);
    }

    public void setCustomMarker(int n, Shape shape) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setCustomMarker(shape);
    }

    public void setXColumnVisible(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setXColumnVisible(bl);
    }

    public void setYColumnVisible(int n, boolean bl) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setYColumnVisible(bl);
    }

    public void setMarkerSize(int n, int n2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setMarkerSize(n2);
    }

    public void setLineColor(int n, Color color) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setLineColor(color);
    }

    public void setXYColumnNames(int n, String string, String string2, String string3) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setXYColumnNames(string, string2, string3);
    }

    public void setXYColumnNames(int n, String string, String string2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.setXYColumnNames(string, string2);
    }

    public boolean isMeasured() {
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            if (!dataset.isMeasured()) continue;
            return true;
        }
        return false;
    }

    public double getXMin() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            if (!dataset.isMeasured()) continue;
            d = Math.min(d, dataset.getXMin());
        }
        return d;
    }

    public double getXMax() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            if (!dataset.isMeasured()) continue;
            d = Math.max(d, dataset.getXMax());
        }
        return d;
    }

    public double getYMin() {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            if (!dataset.isMeasured()) continue;
            d = Math.min(d, dataset.getYMin());
        }
        return d;
    }

    public double getYMax() {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            if (!dataset.isMeasured()) continue;
            d = Math.max(d, dataset.getYMax());
        }
        return d;
    }

    public double[] getXPoints(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        return dataset.getXPoints();
    }

    public double[] getYPoints(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        return dataset.getYPoints();
    }

    public boolean isSorted(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        return dataset.isSorted();
    }

    public boolean isConnected(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        return dataset.isConnected();
    }

    public int getColumnCount() {
        int n = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            n += dataset.getColumnCount();
        }
        return n;
    }

    public int getRowCount() {
        int n = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            n = Math.max(n, dataset.getRowCount());
        }
        return n;
    }

    public String getColumnName(int n) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            int n3 = dataset.getColumnCount();
            if ((n2 += n3) <= n) continue;
            int n4 = Math.abs(n2 - n3 - n);
            return dataset.getColumnName(n4);
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        if (this.datasets.size() == 0) {
            return null;
        }
        int n3 = 0;
        for (int i = 0; i < this.datasets.size(); ++i) {
            Dataset dataset = (Dataset)this.datasets.get(i);
            int n4 = dataset.getColumnCount();
            if ((n3 += n4) <= n2) continue;
            if (n >= dataset.getRowCount()) {
                return null;
            }
            int n5 = Math.abs(n3 - n4 - n2);
            return dataset.getValueAt(n, n5);
        }
        return null;
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Double == null ? (class$java$lang$Double = DatasetManager.class$("java.lang.Double")) : class$java$lang$Double;
    }

    public void append(int n, double d, double d2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.append(d, d2);
    }

    public void append(int n, double d, double d2, double d3, double d4) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.append(d, d2, d3, d4);
    }

    public void append(int n, double[] dArray, double[] dArray2) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.append(dArray, dArray2);
    }

    public void append(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.append(dArray, dArray2, dArray3, dArray4);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).draw(drawingPanel, graphics);
        }
    }

    public void clear(int n) {
        this.checkDatasetIndex(n);
        Dataset dataset = (Dataset)this.datasets.get(n);
        dataset.clear();
    }

    public void clear() {
        for (int i = 0; i < this.datasets.size(); ++i) {
            ((Dataset)this.datasets.get(i)).clear();
        }
    }

    public void removeDatasets() {
        this.clear();
        this.datasets.clear();
    }

    public Dataset getDataset(int n) {
        this.checkDatasetIndex(n);
        return (Dataset)this.datasets.get(n);
    }

    public ArrayList getDatasets() {
        return (ArrayList)this.datasets.clone();
    }

    public int addDataset(Dataset dataset) {
        if (this.linked) {
            dataset.setXColumnVisible(false);
        }
        this.datasets.add(dataset);
        return this.datasets.size() - 1;
    }

    public Dataset removeDataset(int n) {
        if (n < 0 || n > this.datasets.size() - 1) {
            return null;
        }
        return (Dataset)this.datasets.remove(n);
    }

    public int getDatasetIndex(String string) {
        for (int i = 0; i < this.datasets.size(); ++i) {
            String string2 = ((Dataset)this.datasets.get(i)).getYColumnName();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Map getProperties() {
        return this.properties;
    }

    public String toString() {
        if (this.datasets.size() == 0) {
            return "No data in datasets.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.datasets.size(); ++i) {
            stringBuffer.append("Dataset ");
            stringBuffer.append(i);
            stringBuffer.append('\n');
            stringBuffer.append(this.datasets.get(i).toString());
        }
        return stringBuffer.toString();
    }

    public void setXYColumnNames(String string, String string2) {
        this.xColumnName = string;
        this.yColumnName = string2;
        int n = this.datasets.size();
        for (int i = 0; i < n; ++i) {
            ((Dataset)this.datasets.get(i)).setXYColumnNames(string, string2);
        }
    }

    protected void checkDatasetIndex(int n) {
        while (n >= this.datasets.size()) {
            Dataset dataset = new Dataset(DisplayColors.getMarkerColor(n), DisplayColors.getLineColor(n), this.connected);
            if (this.linked && this.datasets.size() > 0) {
                dataset.setXColumnVisible(false);
            }
            dataset.setSorted(this.sorted);
            dataset.setXYColumnNames(this.xColumnName, this.yColumnName);
            dataset.setMarkerShape(this.markerShape);
            this.datasets.add(dataset);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DatasetManager datasetManager = (DatasetManager)object;
            xMLControl.setValue("connected", datasetManager.connected);
            xMLControl.setValue("sorted", datasetManager.sorted);
            xMLControl.setValue("maker_shape", datasetManager.markerShape);
            xMLControl.setValue("stride", datasetManager.stride);
            xMLControl.setValue("linked", datasetManager.linked);
            xMLControl.setValue("x_column_name", datasetManager.xColumnName);
            xMLControl.setValue("y_column_name", datasetManager.yColumnName);
            xMLControl.setValue("datasets", datasetManager.datasets);
        }

        public Object createObject(XMLControl xMLControl) {
            return new DatasetManager();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DatasetManager datasetManager = (DatasetManager)object;
            datasetManager.connected = xMLControl.getBoolean("connected");
            datasetManager.sorted = xMLControl.getBoolean("sorted");
            datasetManager.markerShape = xMLControl.getInt("maker_shape");
            datasetManager.stride = xMLControl.getInt("stride");
            datasetManager.linked = xMLControl.getBoolean("linked");
            datasetManager.xColumnName = xMLControl.getString("x_column_name");
            datasetManager.yColumnName = xMLControl.getString("y_column_name");
            Collection collection = (Collection)xMLControl.getObject("datasets");
            datasetManager.removeDatasets();
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    datasetManager.datasets.add((Dataset)iterator.next());
                }
            }
            return object;
        }
    }
}

