/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;

public class DataFunction
extends Dataset {
    DatasetManager inputData;
    ParsedMultiVarFunction function;
    String functionString;
    String inputString;
    int varCount;
    ArrayList constantNames = new ArrayList();
    ArrayList data = new ArrayList();

    public DataFunction(DatasetManager datasetManager) {
        this.inputData = datasetManager;
        this.setXYColumnNames(datasetManager.getDataset(0).getXColumnName(), "Var");
        this.setFunction("0");
    }

    public void setFunction(String string) {
        this.varCount = this.getVarCount();
        try {
            this.function = new ParsedMultiVarFunction(string, this.getVarNames());
            this.functionString = string;
            this.inputString = string;
            this.refresh();
        }
        catch (ParserException parserException) {
            this.setFunction("0");
            this.inputString = string;
        }
    }

    public String getFunction() {
        return this.functionString;
    }

    public void setFunctionName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.setXYColumnNames(this.getXColumnName(), string);
    }

    public String getFunctionName() {
        return this.getYColumnName();
    }

    public String getInputString() {
        return this.inputString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConstant(String string, double d) {
        Map map;
        Map map2 = map = this.inputData.getProperties();
        synchronized (map2) {
            map.put(string, new Double(d));
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstant(String string) {
        Map map;
        Map map2 = map = this.inputData.getProperties();
        synchronized (map2) {
            map.remove(string);
        }
        this.refresh();
    }

    public void refresh() {
        super.clear();
        if (this.function == null) {
            return;
        }
        if (this.varCount != this.getVarCount()) {
            this.setFunction(this.getFunction());
            return;
        }
        double[][] dArray = this.getData();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            for (int j = 0; j < dArray.length; ++j) {
                dArray2[j] = dArray[j][i];
            }
            super.append(dArray2[0], this.function.evaluate(dArray2));
        }
    }

    public String toString() {
        return this.getFunctionName();
    }

    public void append(double d, double d2) {
    }

    public void append(double d, double d2, double d3, double d4) {
    }

    public void append(double[] dArray, double[] dArray2) {
    }

    public void append(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
    }

    public void clear() {
    }

    private double[][] getData() {
        double[] dArray;
        Object object;
        int n = 0;
        this.data.clear();
        Iterator iterator = ((AbstractList)this.inputData.getDatasets()).iterator();
        while (iterator.hasNext()) {
            object = (Dataset)iterator.next();
            if (object == this) continue;
            if (this.data.isEmpty()) {
                dArray = ((Dataset)object).getXPoints();
                n = dArray.length;
                this.data.add(dArray);
            }
            this.data.add(((Dataset)object).getYPoints());
        }
        object = this.inputData.getProperties();
        iterator = ((AbstractList)this.constantNames).iterator();
        while (iterator.hasNext()) {
            dArray = new double[n];
            Double d = (Double)object.get(iterator.next());
            for (int i = 0; i < n; ++i) {
                dArray[i] = d;
            }
            this.data.add(dArray);
        }
        return (double[][])this.data.toArray((T[])new double[0][0]);
    }

    private int getVarCount() {
        ArrayList arrayList = this.inputData.getDatasets();
        int n = arrayList.contains(this) ? arrayList.size() - 1 : arrayList.size();
        return n + this.getConstantNames().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getConstantNames() {
        Map map;
        this.constantNames.clear();
        Map map2 = map = this.inputData.getProperties();
        synchronized (map2) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!(map.get(string) instanceof Double)) continue;
                this.constantNames.add(string);
            }
        }
        return this.constantNames;
    }

    private String[] getVarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = ((AbstractList)this.inputData.getDatasets()).iterator();
        while (iterator.hasNext()) {
            Dataset dataset = (Dataset)iterator.next();
            if (dataset == this) continue;
            String string = null;
            if (arrayList.isEmpty()) {
                string = GUIUtils.removeSubscripting(dataset.getXColumnName());
                arrayList.add(string);
            }
            string = GUIUtils.removeSubscripting(dataset.getYColumnName());
            arrayList.add(string);
        }
        arrayList.addAll(this.constantNames);
        return arrayList.toArray(new String[0]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DataFunction dataFunction = (DataFunction)object;
            xMLControl.setValue("function", dataFunction.getFunction());
            xMLControl.setValue("function_name", dataFunction.getFunctionName());
            xMLControl.setValue("datasetID", dataFunction.datasetID);
        }

        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DataFunction dataFunction = (DataFunction)object;
            dataFunction.setFunction(xMLControl.getString("function"));
            dataFunction.setFunctionName(xMLControl.getString("function_name"));
            dataFunction.setID(xMLControl.getInt("datasetID"));
            return object;
        }
    }
}

