/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.BoundedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.TextLine;

public class BoundedTextLine
extends BoundedImage {
    Font defaultFont = new Font("Dialog", 1, 12);
    TextLine textLine;
    int desent = 0;
    int gutter = 6;

    public BoundedTextLine(String string, double d, double d2) {
        super(new BufferedImage(1, 1, 2), d, d2);
        this.textLine = new TextLine(string);
        this.textLine.setFont(this.defaultFont);
        this.color = Color.BLACK;
    }

    public void setFont(Font font) {
        this.textLine.setFont(font);
    }

    public Font getFont() {
        return this.textLine.getFont();
    }

    void checkImageSize(DrawingPanel drawingPanel, Graphics graphics) {
        Font font = graphics.getFont();
        Rectangle2D rectangle2D = font.getStringBounds(this.textLine.text, ((Graphics2D)graphics).getFontRenderContext());
        this.gutter = (int)rectangle2D.getHeight() / 2;
        if (this.image.getWidth(null) != (int)rectangle2D.getWidth() + 1 || this.image.getHeight(null) != (int)rectangle2D.getHeight() + 1 + this.gutter) {
            this.image = new BufferedImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1 + this.gutter, 2);
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
            this.desent = -((int)rectangle2D.getY());
        }
        graphics.setFont(font);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.checkImageSize(drawingPanel, graphics);
        Graphics graphics2 = this.image.getGraphics();
        this.textLine.setColor(this.color);
        this.textLine.drawText(graphics2, 0, this.desent + this.gutter / 2);
        graphics2.dispose();
        Composite composite = ((Graphics2D)graphics).getComposite();
        ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(10));
        super.draw(drawingPanel, graphics);
        ((Graphics2D)graphics).setComposite(composite);
    }
}

