/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.AbstractInteractive;
import org.opensourcephysics.display.BoundedImage;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveArrow;
import org.opensourcephysics.display.InteractiveCenteredArrow;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display.Selectable;

public class BoundedShape
extends InteractiveShape
implements Selectable {
    static int CENTER = 0;
    static int BOTTOM = 1;
    static int LEFT = 2;
    static int TOP = 3;
    static int RIGHT = 4;
    static int CORNER = 5;
    static int NONE = 6;
    int hotspot = NONE;
    int delta = 3;
    int deltaSqr = this.delta * this.delta;
    int d2 = 2 * this.delta + 1;
    boolean selected = false;
    boolean hideBounds = false;
    Color boundsColor = new Color(128, 128, 255);
    boolean widthDrag = false;
    boolean heightDrag = false;
    boolean xyDrag = true;
    boolean rotateDrag = false;
    Shape pixelBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    Point2D[] hotSpots = new Point2D[6];
    XYDelegate xyDelegate = new XYDelegate();

    public BoundedShape(Shape shape, double d, double d2) {
        super(shape, d, d2);
        int n = this.hotSpots.length;
        for (int i = 0; i < n; ++i) {
            this.hotSpots[i] = new Point2D.Float(0.0f, 0.0f);
        }
    }

    public static BoundedShape createBoundedRectangle(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4);
        return new BoundedShape(double_, d, d2);
    }

    public static BoundedShape createBoundedTriangle(double d, double d2, double d3, double d4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(-d3 / 2.0), (float)(-d4 / 2.0));
        generalPath.lineTo((float)(d3 / 2.0), (float)(-d4 / 2.0));
        generalPath.lineTo(0.0f, (float)(d4 / 2.0));
        generalPath.closePath();
        GeneralPath generalPath2 = generalPath;
        return new BoundedShape(generalPath2, d, d2);
    }

    public static BoundedShape createBoundedArrow(double d, double d2, double d3, double d4) {
        InteractiveArrow interactiveArrow = new InteractiveArrow(d, d2, d3, d4);
        interactiveArrow.hideBounds = false;
        return interactiveArrow;
    }

    public static BoundedShape createBoundedCenteredArrow(double d, double d2, double d3, double d4) {
        InteractiveCenteredArrow interactiveCenteredArrow = new InteractiveCenteredArrow(d, d2, d3, d4);
        interactiveCenteredArrow.hideBounds = false;
        return interactiveCenteredArrow;
    }

    public static BoundedShape createBoundedImage(Image image, double d, double d2) {
        return new BoundedImage(image, d, d2);
    }

    public static BoundedShape createBoundedEllipse(double d, double d2, double d3, double d4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4);
        return new BoundedShape(double_, d, d2);
    }

    public static BoundedShape createBoundedCircle(double d, double d2, double d3) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3);
        return new BoundedShape(double_, d, d2);
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setXYDrag(boolean bl) {
        this.xyDrag = bl;
    }

    public boolean isXYDrag() {
        return this.xyDrag;
    }

    public void setRotateDrag(boolean bl) {
        this.rotateDrag = bl;
    }

    public boolean isRotateDrag() {
        return this.rotateDrag;
    }

    public void setWidthDrag(boolean bl) {
        this.widthDrag = bl;
    }

    public boolean isWidthDrag() {
        return this.widthDrag;
    }

    public void setHeightDrag(boolean bl) {
        this.heightDrag = bl;
    }

    public boolean isHeightDrag() {
        return this.heightDrag;
    }

    public Cursor getPreferredCursor() {
        if (this.xyDrag && this.hotspot == CENTER) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.rotateDrag && this.hotspot == CORNER) {
            return Cursor.getPredefinedCursor(12);
        }
        if (this.widthDrag && this.hotspot == LEFT) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(10) : Cursor.getPredefinedCursor(12);
        }
        if (this.widthDrag && this.hotspot == RIGHT) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(12);
        }
        if (this.heightDrag && this.hotspot == TOP) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(12);
        }
        if (this.heightDrag && this.hotspot == BOTTOM) {
            return this.theta == 0.0 ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(12);
        }
        if (this.selected) {
            return Cursor.getPredefinedCursor(1);
        }
        return Cursor.getPredefinedCursor(12);
    }

    public void toggleSelected() {
        this.selected = !this.selected;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (this.isInside(drawingPanel, n, n2)) {
            return this.xyDelegate;
        }
        return null;
    }

    public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
        this.hotspot = NONE;
        if (!this.enabled) {
            return false;
        }
        if (this.pixelBounds.contains(n, n2) && !this.selected) {
            return true;
        }
        if (this.selected) {
            this.hotspot = this.getHotSpotIndex(n, n2, this.hotSpots);
            return true;
        }
        return false;
    }

    int getHotSpotIndex(int n, int n2, Point2D[] point2DArray) {
        int n3 = point2DArray.length;
        for (int i = 0; i < n3; ++i) {
            double d;
            double d2 = (double)n - point2DArray[i].getX();
            if (!(d2 * d2 + (d = (double)n2 - point2DArray[i].getY()) * d <= (double)this.deltaSqr)) continue;
            return i;
        }
        return NONE;
    }

    void computeScaledHotSpots(Rectangle2D rectangle2D, double d) {
        double d2 = Math.sin(this.theta);
        double d3 = Math.cos(this.theta);
        double d4 = rectangle2D.getCenterX() - this.xoff * this.toPixels.getScaleX();
        double d5 = rectangle2D.getCenterY() - this.yoff * this.toPixels.getScaleY();
        double d6 = rectangle2D.getWidth() / 2.0 + this.xoff * this.toPixels.getScaleX();
        double d7 = rectangle2D.getWidth() / 2.0 - this.xoff * this.toPixels.getScaleX();
        double d8 = rectangle2D.getHeight() / 2.0 + this.yoff * this.toPixels.getScaleY();
        double d9 = rectangle2D.getHeight() / 2.0 - this.yoff * this.toPixels.getScaleY();
        this.hotSpots[CENTER].setLocation(d4, d5);
        this.hotSpots[BOTTOM].setLocation(d4 + this.xoff * this.toPixels.getScaleX() * d3 + d8 * d2 / d, d5 - this.xoff * this.toPixels.getScaleX() * d2 + d8 * d3);
        this.hotSpots[LEFT].setLocation(d4 - d7 * d3 + this.yoff * this.toPixels.getScaleY() * d2, d5 + d * d7 * d2 + this.yoff * this.toPixels.getScaleY() * d3);
        this.hotSpots[TOP].setLocation(d4 + this.xoff * this.toPixels.getScaleX() * d3 - d9 * d2 / d, d5 - this.xoff * this.toPixels.getScaleX() * d2 - d9 * d3);
        this.hotSpots[RIGHT].setLocation(d4 + d6 * d3 + this.yoff * this.toPixels.getScaleY() * d2, d5 - d * d6 * d2 + this.yoff * this.toPixels.getScaleY() * d3);
        this.hotSpots[CORNER].setLocation(d4 + d6 * d3 - d9 * d2 / d, d5 - d6 * d2 * d - d9 * d3);
    }

    void computeFixedHotSpots(Rectangle2D rectangle2D) {
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        double d3 = rectangle2D.getCenterX() - this.xoff;
        double d4 = rectangle2D.getCenterY() + this.yoff;
        double d5 = rectangle2D.getWidth() / 2.0 + this.xoff;
        double d6 = this.xoff - rectangle2D.getWidth() / 2.0;
        double d7 = this.yoff - rectangle2D.getHeight() / 2.0;
        double d8 = rectangle2D.getHeight() / 2.0 + this.yoff;
        this.hotSpots[0].setLocation(d3, d4);
        this.hotSpots[1].setLocation(d3 + this.xoff * d2 - d7 * d, d4 - d7 * d2 - this.xoff * d);
        this.hotSpots[2].setLocation(d3 + d6 * d2 - this.yoff * d, d4 - d6 * d - this.yoff * d2);
        this.hotSpots[3].setLocation(d3 + this.xoff * d2 - d8 * d, d4 - d8 * d2 - this.xoff * d);
        this.hotSpots[4].setLocation(d3 + d5 * d2 - this.yoff * d, d4 - d5 * d - this.yoff * d2);
        this.hotSpots[5].setLocation(d3 + d5 * d2 - d8 * d, d4 - d5 * d - d8 * d2);
    }

    void setHotSpotXY(double d, double d2) {
        if (this.hideBounds) {
            this.setXY(d, d2);
            return;
        }
        if (this.xyDrag && this.selected && this.hotspot == CENTER) {
            this.setXY(d, d2);
        } else if (this.rotateDrag && this.selected && this.hotspot == CORNER) {
            if (this.pixelSized) {
                double d3 = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
                double d4 = d - this.x;
                double d5 = d2 - this.y;
                this.theta = Math.atan2(d3 * d5, d4) - Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
            } else {
                double d6 = d - this.x;
                double d7 = d2 - this.y;
                double d8 = Math.atan2(this.height / 2.0 + this.yoff, this.width / 2.0 + this.xoff);
                double d9 = Math.atan2(d7, d6);
                this.setTheta(d9 - d8);
            }
        } else if (this.widthDrag && this.selected && (this.hotspot == LEFT || this.hotspot == RIGHT)) {
            if (this.pixelSized) {
                double d10 = this.toPixels.getScaleX() * (d - this.x) - this.xoff;
                double d11 = this.toPixels.getScaleY() * (d2 - this.y) + this.yoff;
                this.setWidth(2.0 * Math.sqrt(d10 * d10 + d11 * d11));
            } else {
                double d12 = d - this.x - this.xoff;
                double d13 = d2 - this.y - this.yoff;
                this.setWidth(2.0 * Math.sqrt(d12 * d12 + d13 * d13));
            }
        } else if (this.heightDrag && this.selected && (this.hotspot == TOP || this.hotspot == BOTTOM)) {
            if (this.pixelSized) {
                double d14 = this.toPixels.getScaleX() * (d - this.x) - this.xoff;
                double d15 = this.toPixels.getScaleY() * (d2 - this.y) + this.yoff;
                this.setHeight(2.0 * Math.sqrt(d14 * d14 + d15 * d15));
            } else {
                double d16 = d - this.x - this.xoff;
                double d17 = d2 - this.y - this.yoff;
                this.setHeight(2.0 * Math.sqrt(d16 * d16 + d17 * d17));
            }
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        super.draw(drawingPanel, graphics);
        if (this.pixelSized) {
            this.drawFixedBounds(drawingPanel, graphics);
        } else {
            this.drawScaledBounds(drawingPanel, graphics);
        }
    }

    private void drawScaledBounds(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        double d = -this.toPixels.getScaleY() / this.toPixels.getScaleX();
        if (this.theta == 0.0) {
            object = this.toPixels.createTransformedShape(this.shape.getBounds2D());
            this.computeScaledHotSpots(object.getBounds2D(), d);
            this.pixelBounds = object.getBounds2D();
        } else {
            object = AffineTransform.getRotateInstance(-this.theta, this.x, this.y).createTransformedShape(this.shape);
            object = this.toPixels.createTransformedShape((Shape)object);
            this.computeScaledHotSpots(object.getBounds2D(), d);
            this.pixelBounds = object.getBounds2D();
            if (drawingPanel.isSquareAspect()) {
                this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, ((Rectangle2D)this.pixelBounds).getCenterX() - this.xoff * this.toPixels.getScaleX(), ((Rectangle2D)this.pixelBounds).getCenterY() - this.yoff * this.toPixels.getScaleY()).createTransformedShape(this.pixelBounds);
            } else {
                double d2 = ((Rectangle2D)this.pixelBounds).getCenterX() - this.xoff * this.toPixels.getScaleX();
                double d3 = ((Rectangle2D)this.pixelBounds).getCenterY() - this.yoff * this.toPixels.getScaleY();
                this.pixelBounds = AffineTransform.getTranslateInstance(-d2, -d3).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getScaleInstance(1.0, 1.0 / d).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getRotateInstance(-this.theta).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getScaleInstance(1.0, d).createTransformedShape(this.pixelBounds);
                this.pixelBounds = AffineTransform.getTranslateInstance(d2, d3).createTransformedShape(this.pixelBounds);
            }
        }
        if (!this.selected || this.hideBounds) {
            return;
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setPaint(this.boundsColor);
        ((Graphics2D)object).draw(this.pixelBounds);
        if (this.rotateDrag) {
            ((Graphics)object).fillOval((int)this.hotSpots[CORNER].getX() - this.delta, (int)this.hotSpots[CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[TOP].getX() - this.delta, (int)this.hotSpots[TOP].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).fillRect((int)this.hotSpots[BOTTOM].getX() - this.delta, (int)this.hotSpots[BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[LEFT].getX() - this.delta, (int)this.hotSpots[LEFT].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).fillRect((int)this.hotSpots[RIGHT].getX() - this.delta, (int)this.hotSpots[RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[CENTER].getX() - this.delta, (int)this.hotSpots[CENTER].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).setColor(this.edgeColor);
            ((Graphics)object).fillOval((int)this.hotSpots[CENTER].getX() - 1, (int)this.hotSpots[CENTER].getY() - 1, 3, 3);
            ((Graphics2D)object).setPaint(this.boundsColor);
        }
        graphics.setColor(Color.BLACK);
    }

    private void drawFixedBounds(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (this.theta == 0.0) {
            object = new Point2D.Double(this.x, this.y);
            object = this.toPixels.transform((Point2D)object, (Point2D)object);
            Shape shape = AffineTransform.getTranslateInstance(-this.x + ((Point2D)object).getX() + this.xoff, -this.y + ((Point2D)object).getY() - this.yoff).createTransformedShape(this.shape.getBounds2D());
            this.computeFixedHotSpots(shape.getBounds2D());
            this.pixelBounds = shape.getBounds2D();
        } else {
            object = new Point2D.Double(this.x, this.y);
            object = this.toPixels.transform((Point2D)object, (Point2D)object);
            Shape shape = AffineTransform.getTranslateInstance(-this.x + ((Point2D)object).getX() + this.xoff, -this.y + ((Point2D)object).getY() - this.yoff).createTransformedShape(this.shape);
            this.computeFixedHotSpots(shape.getBounds2D());
            this.pixelBounds = shape.getBounds2D();
            this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, ((Point2D)object).getX(), ((Point2D)object).getY()).createTransformedShape(this.pixelBounds);
        }
        if (!this.selected || this.hideBounds) {
            return;
        }
        object = (Graphics2D)graphics;
        ((Graphics2D)object).setPaint(this.boundsColor);
        ((Graphics2D)object).draw(this.pixelBounds);
        if (this.rotateDrag) {
            ((Graphics)object).fillOval((int)this.hotSpots[CORNER].getX() - this.delta, (int)this.hotSpots[CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[TOP].getX() - this.delta, (int)this.hotSpots[TOP].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).fillRect((int)this.hotSpots[BOTTOM].getX() - this.delta, (int)this.hotSpots[BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[LEFT].getX() - this.delta, (int)this.hotSpots[LEFT].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).fillRect((int)this.hotSpots[RIGHT].getX() - this.delta, (int)this.hotSpots[RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        if (this.xyDrag) {
            ((Graphics)object).fillRect((int)this.hotSpots[CENTER].getX() - this.delta, (int)this.hotSpots[CENTER].getY() - this.delta, this.d2, this.d2);
            ((Graphics)object).setColor(this.edgeColor);
            ((Graphics)object).fillOval((int)this.hotSpots[CENTER].getX() - 1, (int)this.hotSpots[CENTER].getY() - 1, 3, 3);
            ((Graphics2D)object).setPaint(this.boundsColor);
        }
        graphics.setColor(Color.BLACK);
    }

    public String toString() {
        return "BoundedShape:\n \t shape=" + this.shapeClass + "\n \t x=" + this.x + "\n \t y=" + this.y + "\n \t width=" + this.width + "\n \t height=" + this.height + "\n \t theta=" + this.theta;
    }

    public static XML.ObjectLoader getLoader() {
        return new BoundedShapeLoader();
    }

    class XYDelegate
    extends AbstractInteractive
    implements Selectable {
        XYDelegate() {
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        }

        public boolean isInside(DrawingPanel drawingPanel, int n, int n2) {
            return BoundedShape.this.isInside(drawingPanel, n, n2);
        }

        public void setXY(double d, double d2) {
            BoundedShape.this.setHotSpotXY(d, d2);
        }

        public void setSelected(boolean bl) {
            BoundedShape.this.setSelected(bl);
        }

        public void toggleSelected() {
            BoundedShape.this.toggleSelected();
        }

        public boolean isSelected() {
            return BoundedShape.this.isSelected();
        }

        public Cursor getPreferredCursor() {
            return BoundedShape.this.getPreferredCursor();
        }
    }

    protected static class BoundedShapeLoader
    extends InteractiveShape.InteractiveShapeLoader {
        protected BoundedShapeLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            super.saveObject(xMLControl, object);
            BoundedShape boundedShape = (BoundedShape)object;
            xMLControl.setValue("xy drag", boundedShape.isXYDrag());
            xMLControl.setValue("width drag", boundedShape.isWidthDrag());
            xMLControl.setValue("height drag", boundedShape.isHeightDrag());
            xMLControl.setValue("rotate drag", boundedShape.isRotateDrag());
        }

        public Object createObject(XMLControl xMLControl) {
            return new BoundedShape(new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0), 0.0, 0.0);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            BoundedShape boundedShape = (BoundedShape)object;
            boundedShape.setXYDrag(xMLControl.getBoolean("xy drag"));
            boundedShape.setWidthDrag(xMLControl.getBoolean("width drag"));
            boundedShape.setHeightDrag(xMLControl.getBoolean("height drag"));
            boundedShape.setRotateDrag(xMLControl.getBoolean("rotate drag"));
            super.loadObject(xMLControl, object);
            return boundedShape;
        }
    }
}

