/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.DrawingPanel;

public class BoundedImage
extends BoundedShape
implements ImageObserver {
    protected Image image;

    public BoundedImage(Image image, double d, double d2) {
        super(null, d, d2);
        this.image = image;
        this.width = image.getWidth(this);
        this.width = Math.max(0.0, this.width);
        this.height = image.getHeight(this);
        this.height = Math.max(0.0, this.height);
        this.shapeClass = image.getClass().getName();
        this.setPixelSized(true);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.toPixels = drawingPanel.getPixelTransform();
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = this.toPixels.transform(point2D, point2D);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(point2D.getX(), point2D.getY());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-this.width / 2.0, -this.height / 2.0);
        affineTransform.rotate(-this.theta, this.width / 2.0, this.height / 2.0);
        affineTransform.scale(this.width / (double)this.image.getWidth(null), this.height / (double)this.image.getHeight(null));
        graphics2D.drawImage(this.image, affineTransform, null);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
        this.drawFixedBounds(drawingPanel, graphics);
    }

    private void drawFixedBounds(DrawingPanel drawingPanel, Graphics graphics) {
        Point2D point2D = new Point2D.Double(this.x, this.y);
        point2D = this.toPixels.transform(point2D, point2D);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - this.width / 2.0, point2D.getY() - this.height / 2.0, this.width, this.height);
        this.computeFixedHotSpots(double_.getBounds2D());
        this.pixelBounds = double_.getBounds2D();
        if (this.theta != 0.0) {
            this.pixelBounds = AffineTransform.getRotateInstance(-this.theta, point2D.getX(), point2D.getY()).createTransformedShape(this.pixelBounds);
        }
        if (!this.selected) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.boundsColor);
        graphics2D.draw(this.pixelBounds);
        if (this.xyDrag) {
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.CENTER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CENTER].getY() - this.delta, this.d2, this.d2);
            graphics2D.setColor(this.edgeColor);
            graphics2D.fillOval((int)this.hotSpots[BoundedShape.CENTER].getX() - 1, (int)this.hotSpots[BoundedShape.CENTER].getY() - 1, 3, 3);
            graphics2D.setPaint(this.boundsColor);
        }
        if (this.rotateDrag) {
            graphics2D.fillOval((int)this.hotSpots[BoundedShape.CORNER].getX() - this.delta, (int)this.hotSpots[BoundedShape.CORNER].getY() - this.delta, this.d2, this.d2);
        }
        if (this.heightDrag) {
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.TOP].getX() - this.delta, (int)this.hotSpots[BoundedShape.TOP].getY() - this.delta, this.d2, this.d2);
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.BOTTOM].getX() - this.delta, (int)this.hotSpots[BoundedShape.BOTTOM].getY() - this.delta, this.d2, this.d2);
        }
        if (this.widthDrag) {
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.LEFT].getX() - this.delta, (int)this.hotSpots[BoundedShape.LEFT].getY() - this.delta, this.d2, this.d2);
            graphics2D.fillRect((int)this.hotSpots[BoundedShape.RIGHT].getX() - this.delta, (int)this.hotSpots[BoundedShape.RIGHT].getY() - this.delta, this.d2, this.d2);
        }
        graphics.setColor(Color.BLACK);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 1) == 1) {
            this.width = n4;
        }
        if ((n & 2) == 1) {
            this.height = n5;
        }
        return (n & 0x20) != 1;
    }
}

