/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.ArrowLoader;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Arrow
implements Drawable {
    protected float headSize = 8.0f;
    protected Color color = Color.black;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double a = 0.0;
    protected double b = 0.0;

    public Arrow(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.a = d3;
        this.b = d4;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.setXY(d, this.y);
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.setXY(this.x, d);
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setXlength(double d) {
        this.a = d;
    }

    public void setYlength(double d) {
        this.b = d;
    }

    public double getXlength() {
        return this.a;
    }

    public double getYlength() {
        return this.b;
    }

    public float getHeadSize() {
        return this.headSize;
    }

    public void setHeadSize(float f) {
        this.headSize = f;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = drawingPanel.getPixelTransform();
        graphics2D.setPaint(this.color);
        graphics2D.draw(affineTransform.createTransformedShape(new Line2D.Double(this.x, this.y, this.x + this.a, this.y + this.b)));
        Point2D point2D = new Point2D.Double(this.x + this.a, this.y + this.b);
        point2D = affineTransform.transform(point2D, point2D);
        double d = drawingPanel.isSquareAspect() ? 1.0 : -affineTransform.getScaleX() / affineTransform.getScaleY();
        Shape shape = this.getHead(Math.atan2(this.b, d * this.a));
        Shape shape2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()).createTransformedShape(shape);
        graphics2D.fill(shape2);
        graphics2D.setPaint(Color.BLACK);
    }

    protected Shape getHead(double d) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(1.0f, 0.0f);
        generalPath.lineTo(-this.headSize, -this.headSize / 2.0f);
        generalPath.lineTo(-this.headSize, this.headSize / 2.0f);
        generalPath.closePath();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-d);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        return shape;
    }

    public static XML.ObjectLoader getLoader() {
        return new ArrowLoader();
    }
}

