/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.applets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextFrame;

public class FrameApplet
extends JApplet
implements Renderable {
    JFrame mainFrame = null;
    String targetClassName;
    String contentName;
    ArrayList newFrames = new ArrayList();
    ArrayList existingFrames = new ArrayList();
    Class target;
    String[] args = null;
    Renderable renderPanel;
    boolean singleFrame = true;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$opensourcephysics$display$Renderable;

    public String getParameter(String string, String string2) {
        return this.getParameter(string) != null ? this.getParameter(string) : string2;
    }

    public void init() {
        String string;
        super.init();
        OSPRuntime.applet = this;
        OSPRuntime.appletMode = true;
        if (this.getParameter("showLog", "false").toLowerCase().trim().equals("true")) {
            OSPLog.showLog();
        }
        if ((string = this.getParameter("xmldata", null)) != null) {
            this.args = new String[1];
            this.args[0] = string;
        }
        this.targetClassName = this.getParameter("target", null);
        if (this.targetClassName == null) {
            this.targetClassName = this.getParameter("app", null);
        }
        this.contentName = this.getParameter("content", null);
        this.singleFrame = !this.getParameter("singleframe", "true").trim().equalsIgnoreCase("false");
    }

    public void start() {
        int n;
        int n2;
        Object object;
        if (this.mainFrame != null) {
            return;
        }
        this.createTarget();
        if (this.contentName != null) {
            object = Frame.getFrames();
            n2 = ((Frame[])object).length;
            for (n = 0; n < n2; ++n) {
                if (!(object[n] instanceof JFrame) || !object[n].getName().equalsIgnoreCase(this.contentName)) continue;
                this.mainFrame = (JFrame)object[n];
                break;
            }
        }
        if (this.mainFrame == null) {
            System.out.println("Main frame not found.");
            return;
        }
        this.removeWindowListeners(this.mainFrame);
        ((Component)this.mainFrame).setVisible(false);
        if (!this.mainFrame.isActive()) {
            this.mainFrame.dispose();
        }
        object = this.mainFrame.getContentPane();
        if (this.mainFrame instanceof OSPFrame && ((OSPFrame)this.mainFrame).isAnimated()) {
            this.renderPanel = (Renderable)((Object)GUIUtils.findInstance((Container)object, class$org$opensourcephysics$display$Renderable == null ? (class$org$opensourcephysics$display$Renderable = FrameApplet.class$("org.opensourcephysics.display.Renderable")) : class$org$opensourcephysics$display$Renderable));
        }
        this.getRootPane().setContentPane((Container)object);
        this.getRootPane().requestFocus();
        if (!this.singleFrame) {
            OSPRuntime.appletMode = false;
            n2 = this.newFrames.size();
            for (n = 0; n < n2; ++n) {
                if (!(this.newFrames.get(n) instanceof OSPFrame)) continue;
                ((OSPFrame)this.newFrames.get(n)).setKeepHidden(false);
            }
            GUIUtils.showDrawingAndTableFrames();
        }
    }

    private void removeWindowListeners(Window window) {
        WindowListener[] windowListenerArray = window.getWindowListeners();
        int n = windowListenerArray.length;
        for (int i = 0; i < n; ++i) {
            this.mainFrame.removeWindowListener(windowListenerArray[i]);
        }
    }

    public BufferedImage render() {
        if (this.renderPanel != null) {
            return this.renderPanel.render();
        }
        return null;
    }

    public BufferedImage render(BufferedImage bufferedImage) {
        if (this.renderPanel != null) {
            this.renderPanel.render(bufferedImage);
        }
        return bufferedImage;
    }

    static boolean isLaunchable(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FrameApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public void destroy() {
        this.disposeOwnedFrames();
        this.target = null;
        this.mainFrame = null;
        super.destroy();
    }

    private Class createTarget() {
        Class<?> clazz = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            clazz = classLoader.loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: " + this.targetClassName);
            return null;
        }
        if (!FrameApplet.isLaunchable(clazz)) {
            System.err.println("Main method not found in " + this.targetClassName);
            return null;
        }
        Frame[] frameArray = Frame.getFrames();
        this.existingFrames.clear();
        int n = frameArray.length;
        for (int i = 0; i < n; ++i) {
            this.existingFrames.add(frameArray[i]);
        }
        String string = this.getParameter("htmldata", null);
        if (string != null) {
            TextFrame textFrame = new TextFrame(string, clazz);
            ((Component)textFrame).setVisible(true);
        }
        try {
            Method method = clazz.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = FrameApplet.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            method.invoke(clazz, new Object[]{this.args});
            frameArray = Frame.getFrames();
            int n2 = frameArray.length;
            for (int i = 0; i < n2; ++i) {
                if (frameArray[i] instanceof JFrame && ((JFrame)frameArray[i]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frameArray[i]).setDefaultCloseOperation(1);
                    if (this.mainFrame == null) {
                        this.mainFrame = (JFrame)frameArray[i];
                    }
                }
                if (this.existingFrames.contains(frameArray[i])) continue;
                this.newFrames.add(frameArray[i]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
        }
        if (this.newFrames.size() > 0 && this.mainFrame == null && this.newFrames.get(0) instanceof JFrame) {
            this.mainFrame = (JFrame)this.newFrames.get(0);
        }
        return clazz;
    }

    private void disposeOwnedFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        for (int i = 0; i < n; ++i) {
            if (frameArray[i] instanceof JFrame && ((JFrame)frameArray[i]).getDefaultCloseOperation() == 3) {
                ((JFrame)frameArray[i]).setDefaultCloseOperation(2);
            }
            if (this.existingFrames.contains(frameArray[i])) continue;
            ((Component)frameArray[i]).setVisible(false);
            this.removeWindowListeners(frameArray[i]);
            frameArray[i].dispose();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

