/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTreeNode;

public class XMLTree {
    protected static Icon hiliteIcon;
    protected XMLTreeNode root;
    protected JTree tree;
    protected JScrollPane scroller;
    protected XMLControl control;
    protected List selectedProps = new ArrayList();
    protected Class hilite = class$java$lang$Object == null ? (class$java$lang$Object = XMLTree.class$("java.lang.Object")) : class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opensourcephysics$controls$XMLTree;

    public XMLTree(XMLControl xMLControl) {
        this.control = xMLControl;
        this.createGUI();
    }

    public JTree getTree() {
        return this.tree;
    }

    public List getSelectedProperties() {
        this.selectedProps.clear();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                XMLTreeNode xMLTreeNode = (XMLTreeNode)treePathArray[i].getLastPathComponent();
                this.selectedProps.add(xMLTreeNode.getProperty());
            }
        }
        return this.selectedProps;
    }

    public JScrollPane getScrollPane() {
        return this.scroller;
    }

    public void setHighlightedClass(Class clazz) {
        if (clazz != null) {
            this.hilite = clazz;
            this.scroller.repaint();
        }
    }

    public Class getHighlightedClass() {
        return this.hilite;
    }

    public void selectHighlightedProperties() {
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            XMLTreeNode xMLTreeNode = (XMLTreeNode)enumeration.nextElement();
            XMLProperty xMLProperty = xMLTreeNode.getProperty();
            Class clazz = xMLProperty.getPropertyClass();
            if (clazz == null || !this.hilite.isAssignableFrom(clazz)) continue;
            TreePath treePath = new TreePath(xMLTreeNode.getPath());
            this.tree.addSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    public void showHighlightedProperties() {
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            XMLTreeNode xMLTreeNode = (XMLTreeNode)enumeration.nextElement();
            XMLProperty xMLProperty = xMLTreeNode.getProperty();
            Class clazz = xMLProperty.getPropertyClass();
            if (clazz == null || !this.hilite.isAssignableFrom(clazz)) continue;
            TreePath treePath = new TreePath(xMLTreeNode.getPath());
            this.tree.scrollPathToVisible(treePath);
        }
    }

    protected void createGUI() {
        String string = "/org/opensourcephysics/resources/controls/images/hilite.gif";
        hiliteIcon = new ImageIcon((class$org$opensourcephysics$controls$XMLTree == null ? (class$org$opensourcephysics$controls$XMLTree = XMLTree.class$("org.opensourcephysics.controls.XMLTree")) : class$org$opensourcephysics$controls$XMLTree).getResource(string));
        this.root = new XMLTreeNode(this.control);
        this.tree = new JTree(this.root);
        this.tree.setCellRenderer(new HighlightRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.scroller = new JScrollPane(this.tree);
        this.scroller.setPreferredSize(new Dimension(200, 200));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class HighlightRenderer
    extends DefaultTreeCellRenderer {
        private HighlightRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            XMLTreeNode xMLTreeNode = (XMLTreeNode)object;
            XMLProperty xMLProperty = xMLTreeNode.getProperty();
            Class clazz = xMLProperty.getPropertyClass();
            if (clazz != null && XMLTree.this.hilite.isAssignableFrom(clazz)) {
                this.setIcon(hiliteIcon);
            }
            return this;
        }
    }
}

