/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;

public class XMLTableInspector
extends JDialog
implements PropertyChangeListener {
    static String frameTitle = ControlsRes.getString("XMLTableInspector.Title");
    private XMLTable table;
    private boolean changed;

    public XMLTableInspector(XMLControl xMLControl) {
        this(xMLControl, true, true);
    }

    public XMLTableInspector(XMLControl xMLControl, boolean bl) {
        this(xMLControl, bl, true);
    }

    public XMLTableInspector(XMLControl xMLControl, boolean bl, boolean bl2) {
        super((Frame)null, bl2);
        this.createGUI();
        XMLTable xMLTable = new XMLTable(xMLControl);
        xMLTable.setEditable(bl);
        this.setTable(xMLTable);
        String string = XML.getExtension(xMLControl.getObjectClassName());
        this.setTitle(frameTitle + " " + string + " \"" + xMLControl.getPropertyName() + "\" ");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (XMLTableInspector.this.changed) {
                    XMLTableInspector.this.firePropertyChange("xmlData", null, null);
                    XMLTableInspector.this.changed = false;
                }
            }
        });
    }

    public XMLTableInspector(boolean bl, boolean bl2) {
        super((Frame)null, bl2);
        this.table = new OSPControlTable(new XMLControlElement());
        this.table.setEditable(bl);
        this.table.addPropertyChangeListener("cell", this);
        this.table.addPropertyChangeListener("tableData", this);
        this.createGUI();
        String string = XML.getExtension(this.getXMLControl().getObjectClassName());
        this.setTitle(frameTitle + " " + string + " \"" + this.getXMLControl().getPropertyName() + "\" ");
    }

    public Control getControl() {
        return this.table instanceof Control ? (Control)((Object)this.table) : this.table.tableModel.control;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changed = true;
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public XMLTable getTable() {
        return this.table;
    }

    public void setTable(XMLTable xMLTable) {
        if (this.table != null) {
            this.table.removePropertyChangeListener("cell", this);
            this.table.removePropertyChangeListener("tableData", this);
            xMLTable.setEditable(this.table.isEditable());
        }
        this.table = xMLTable;
        this.table.addPropertyChangeListener("cell", this);
        this.table.addPropertyChangeListener("tableData", this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.createHorizontalScrollBar();
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    public XMLControl getXMLControl() {
        return this.table.tableModel.control;
    }

    private void createGUI() {
        ((Component)this).setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
    }
}

