/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.AnimationControl;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class SimulationControl
extends AnimationControl
implements SimControl {
    Set fixedParameters = new HashSet();

    public SimulationControl(Simulation simulation) {
        super(simulation);
    }

    public void setParameterToFixed(String string, boolean bl) {
        if (bl) {
            this.fixedParameters.add(string);
        } else {
            this.fixedParameters.remove(string);
        }
        this.table.refresh();
    }

    public boolean isParamterFixed(String string) {
        return this.fixedParameters.contains(string);
    }

    public void setValue(String string, Object object) {
        super.setValue(string, object);
        this.fixedParameters.add(string);
    }

    public void setAdjustableValue(String string, Object object) {
        super.setValue(string, object);
        this.fixedParameters.remove(string);
    }

    public void setValue(String string, double d) {
        super.setValue(string, d);
        this.fixedParameters.add(string);
    }

    public void setAdjustableValue(String string, double d) {
        super.setValue(string, d);
        this.fixedParameters.remove(string);
    }

    public void setValue(String string, int n) {
        super.setValue(string, n);
        this.fixedParameters.add(string);
    }

    public void setAdjustableValue(String string, int n) {
        super.setValue(string, n);
        this.fixedParameters.remove(string);
    }

    public void setValue(String string, boolean bl) {
        super.setValue(string, bl);
        this.fixedParameters.add(string);
    }

    public void removeParameter(String string) {
        super.removeParameter(string);
        this.fixedParameters.remove(string);
    }

    public void setAdjustableValue(String string, boolean bl) {
        super.setValue(string, bl);
        this.fixedParameters.remove(string);
    }

    void resetBtnActionPerformed(ActionEvent actionEvent) {
        Iterator iterator = this.fixedParameters.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.table.setEditable(string, true);
            this.table.setBackgroundColor(string, Color.WHITE);
        }
        this.table.refresh();
        super.resetBtnActionPerformed(actionEvent);
    }

    void startBtnActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.initText)) {
            this.table.setEditable(true);
            Iterator iterator = this.fixedParameters.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.table.setEditable(string, false);
                this.table.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
            }
        } else if (actionEvent.getActionCommand().equals(this.startText)) {
            Iterator iterator = this.table.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.table.setEditable(string, false);
                this.table.setBackgroundColor(string, Control.NOT_EDITABLE_BACKGROUND);
            }
        } else if (actionEvent.getActionCommand().equals(this.stopText)) {
            Iterator iterator = this.table.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.fixedParameters.contains(string)) continue;
                this.table.setEditable(string, true);
                this.table.setBackgroundColor(string, Color.WHITE);
            }
        }
        this.table.refresh();
        super.startBtnActionPerformed(actionEvent);
    }

    public static XML.ObjectLoader getLoader() {
        return new SimulationControlLoader();
    }

    public static SimulationControl createApp(Simulation simulation) {
        SimulationControl simulationControl = new SimulationControl(simulation);
        simulation.setControl(simulationControl);
        return simulationControl;
    }

    public static SimulationControl createApp(Simulation simulation, String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(simulation);
        simulationControl.loadXML(stringArray);
        return simulationControl;
    }

    static class SimulationControlLoader
    extends AnimationControl.AnimationControlLoader {
        SimulationControlLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new SimulationControl(null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            SimulationControl simulationControl = (SimulationControl)object;
            Object[] objectArray = simulationControl.fixedParameters.toArray();
            super.loadObject(xMLControl, object);
            simulationControl.fixedParameters.clear();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                simulationControl.fixedParameters.add(objectArray[i]);
            }
            Iterator iterator = simulationControl.table.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (simulationControl.fixedParameters.contains(string)) continue;
                simulationControl.table.setEditable(string, true);
                simulationControl.table.setBackgroundColor(string, Color.WHITE);
            }
            if (simulationControl.model instanceof AbstractSimulation && xMLControl.getObject("steps per display") != null) {
                ((AbstractSimulation)simulationControl.model).enableStepsPerDisplay(true);
                ((AbstractSimulation)simulationControl.model).setStepsPerDisplay(Integer.parseInt(xMLControl.getString("steps per display")));
            } else {
                ((AbstractSimulation)simulationControl.model).enableStepsPerDisplay(false);
            }
            return object;
        }
    }
}

