/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.EventQueue;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import org.opensourcephysics.controls.VariableNotFoundException;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class ParsableTextArea
extends JTextArea {
    HashMap pendingMap = new LinkedHashMap();
    HashMap currentMap = new LinkedHashMap();
    HashMap lockedMap = new LinkedHashMap();
    boolean locked = false;

    public ParsableTextArea() {
        super(10, 10);
        this.setFont(new Font("Monospaced", 0, 12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String string) throws VariableNotFoundException {
        if (this.locked) {
            HashMap hashMap = this.lockedMap;
            synchronized (hashMap) {
                String string2 = (String)this.lockedMap.get(string);
                if (string2 != null) {
                    return (String)this.lockedMap.get(string);
                }
                throw new VariableNotFoundException("Variable " + string + " not found.");
            }
        }
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            this.updateCurrentMap();
            Object object = this.pendingMap;
            synchronized (object) {
                this.currentMap.putAll(this.pendingMap);
            }
            object = (String)this.currentMap.get(string);
            if (object != null) {
                return object;
            }
        }
        throw new VariableNotFoundException("Variable " + string + " not found.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLockValues(boolean bl) {
        if (this.locked == bl) {
            return;
        }
        this.locked = bl;
        if (this.locked) {
            HashMap hashMap = this.lockedMap;
            synchronized (hashMap) {
                this.lockedMap.clear();
                HashMap hashMap2 = this.currentMap;
                synchronized (hashMap2) {
                    this.updateCurrentMap();
                    this.lockedMap.putAll(this.currentMap);
                }
                hashMap2 = this.pendingMap;
                synchronized (hashMap2) {
                    this.lockedMap.putAll(this.pendingMap);
                }
            }
        }
        this.setValue(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string, String string2) {
        HashMap hashMap;
        Runnable runnable = new Runnable(){

            public void run() {
                ParsableTextArea.this.updateText();
            }
        };
        if (string != null) {
            hashMap = this.pendingMap;
            synchronized (hashMap) {
                this.pendingMap.put(string, string2);
            }
        }
        if (this.locked && string != null) {
            hashMap = this.lockedMap;
            synchronized (hashMap) {
                this.lockedMap.put(string, string2);
            }
        }
        if (!this.locked) {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCurrentMap() {
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            this.updateCurrentMap();
            HashMap hashMap2 = this.pendingMap;
            synchronized (hashMap2) {
                this.currentMap.putAll(this.pendingMap);
            }
            return (HashMap)this.currentMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateText() {
        HashMap hashMap = this.currentMap;
        synchronized (hashMap) {
            Object object = this.pendingMap;
            synchronized (object) {
                if (this.pendingMap.size() == 0) {
                    return;
                }
                this.updateCurrentMap();
                this.currentMap.putAll(this.pendingMap);
                this.pendingMap.clear();
            }
            object = this.currentMap.keySet();
            Iterator iterator = object.iterator();
            StringBuffer stringBuffer = new StringBuffer(object.size() * 25);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(this.currentMap.get(string));
                stringBuffer.append('\n');
            }
            this.setText(stringBuffer.toString());
        }
    }

    private void updateCurrentMap() {
        this.currentMap.clear();
        String string = this.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf("=");
            if (string2 == null || n == -1) continue;
            this.currentMap.put(string2.subSequence(0, n), string2.subSequence(n + 1, string2.length()));
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new ParsableTextAreaLoader();
    }

    static class ParsableTextAreaLoader
    implements XML.ObjectLoader {
        ParsableTextAreaLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            HashMap hashMap = ((ParsableTextArea)object).getCurrentMap();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                xMLControl.setValue(string, hashMap.get(string));
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new ParsableTextArea();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ParsableTextArea parsableTextArea = (ParsableTextArea)object;
            Iterator iterator = xMLControl.getPropertyNames().iterator();
            parsableTextArea.setLockValues(true);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                parsableTextArea.setValue(string, xMLControl.getString(string));
            }
            parsableTextArea.setLockValues(false);
            return object;
        }
    }
}

