/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControlTable;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTable;

public class OSPTableInspector
extends JDialog
implements PropertyChangeListener {
    static final String FRAME_TITLE = ControlsRes.getString("OSPTableInspector.Properties_of");
    private OSPControlTable table;

    public OSPTableInspector() {
        this(true, true);
    }

    public OSPTableInspector(boolean bl) {
        this(bl, true);
    }

    public OSPTableInspector(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    public OSPTableInspector(Frame frame, boolean bl, boolean bl2) {
        super(frame, bl2);
        XMLControlElement xMLControlElement = new XMLControlElement();
        this.table = new OSPControlTable(xMLControlElement);
        this.table.setEditable(bl);
        this.table.addPropertyChangeListener("cell", this);
        this.createGUI();
        String string = XML.getExtension(xMLControlElement.getObjectClassName());
        this.setTitle(FRAME_TITLE + " " + string + " \"" + xMLControlElement.getPropertyName() + "\" ");
    }

    public Control getControl() {
        return this.table;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public XMLTable getTable() {
        return this.table;
    }

    private void createGUI() {
        ((Component)this).setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.createHorizontalScrollBar();
        this.getContentPane().add((Component)jScrollPane, "Center");
        if (!JDialog.isDefaultLookAndFeelDecorated()) {
            return;
        }
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton(ControlsRes.getString("OSPTableInspector.OK"));
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)OSPTableInspector.this).setVisible(false);
                OSPTableInspector.this.dispose();
            }
        });
    }
}

