/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opensourcephysics.controls.ControlsRes;

public class ListChooser
extends JDialog {
    private JPanel checkPane = new JPanel();
    private Object[] objects;
    private boolean[] selections;
    private JCheckBox[] checkBoxes;
    private boolean applyChanges = false;

    public ListChooser(String string, String string2) {
        this(string, string2, null);
    }

    public ListChooser(String string, String string2, Component component) {
        super(JOptionPane.getFrameForComponent(component), true);
        this.setTitle(string);
        JLabel jLabel = new JLabel(" " + string2);
        JButton jButton = new JButton(ControlsRes.getString("Chooser.Button.Cancel"));
        JButton jButton2 = new JButton(ControlsRes.getString("Chooser.Button.OK"));
        JButton jButton3 = new JButton(ControlsRes.getString("Chooser.Button.SelectAll"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)ListChooser.this).setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < ListChooser.this.checkBoxes.length; ++i) {
                    ((ListChooser)ListChooser.this).selections[i] = ListChooser.this.checkBoxes[i].isSelected();
                }
                ListChooser.this.applyChanges = true;
                ((Component)ListChooser.this).setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < ListChooser.this.checkBoxes.length; ++i) {
                    ListChooser.this.checkBoxes[i].setSelected(true);
                }
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.checkPane.setLayout(new BoxLayout(this.checkPane, 1));
        this.checkPane.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.checkPane);
        jScrollPane.setPreferredSize(new Dimension(250, 180));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(jButton2);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel3, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        ((Component)this).setLocation(n, n2);
    }

    public boolean choose(Collection collection, Collection collection2) {
        boolean[] blArray = new boolean[collection.size()];
        return this.choose(collection, collection2, blArray);
    }

    public boolean choose(Collection collection, Collection collection2, boolean[] blArray) {
        boolean[] blArray2 = new boolean[collection.size()];
        return this.choose(collection, collection2, blArray, blArray2);
    }

    public boolean choose(Collection collection, Collection collection2, boolean[] blArray, boolean[] blArray2) {
        this.checkPane.removeAll();
        this.checkBoxes = new JCheckBox[collection.size()];
        this.selections = new boolean[collection.size()];
        this.objects = new Object[collection.size()];
        ArrayList arrayList = new ArrayList();
        if (collection2 != null) {
            arrayList.addAll(collection2);
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.objects[n] = iterator.next();
            this.selections[n] = false;
            this.checkBoxes[n] = arrayList.get(n) == null ? new JCheckBox(this.objects[n].toString()) : new JCheckBox(arrayList.get(n).toString());
            this.checkBoxes[n].setSelected(blArray[n]);
            this.checkBoxes[n].setEnabled(!blArray2[n]);
            this.checkBoxes[n].setBackground(Color.white);
            this.checkPane.add(this.checkBoxes[n]);
            ++n;
        }
        ((Component)this).setVisible(true);
        if (!this.applyChanges) {
            return false;
        }
        for (n = 0; n < this.objects.length; ++n) {
            if (this.selections[n]) continue;
            collection.remove(this.objects[n]);
        }
        return true;
    }
}

