/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;

public abstract class ControlFrame
extends OSPFrame
implements Control {
    static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected Object model;
    protected JMenuItem[] languageItems;
    protected JMenu languageMenu;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu displayMenu;
    protected JMenuItem readItem;
    protected JMenuItem clearItem;
    protected JMenuItem printFrameItem;
    protected JMenuItem saveFrameAsEPSItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem copyItem;
    protected JMenuItem inspectItem;
    protected JMenuItem logToFileItem;
    protected JMenuItem sizeUpItem;
    protected JMenuItem sizeDownItem;
    protected OSPApplication ospApp;
    protected XMLControlElement xmlDefault;
    static /* synthetic */ Class class$org$opensourcephysics$controls$OSPApplication;

    protected ControlFrame(String string) {
        super(string);
        this.createMenuBar();
        this.setName("controlFrame");
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        if (!OSPRuntime.appletMode) {
            this.setJMenuBar(jMenuBar);
        }
        this.fileMenu = new JMenu(ControlsRes.getString("ControlFrame.File"));
        this.editMenu = new JMenu(ControlsRes.getString("ControlFrame.Edit"));
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.editMenu);
        this.readItem = new JMenuItem(ControlsRes.getString("ControlFrame.Load_XML"));
        this.saveAsItem = new JMenuItem(ControlsRes.getString("ControlFrame.Save_XML"));
        this.inspectItem = new JMenuItem(ControlsRes.getString("ControlFrame.Inspect_XML"));
        this.clearItem = new JMenuItem(ControlsRes.getString("ControlFrame.Clear_XML"));
        this.copyItem = new JMenuItem(ControlsRes.getString("ControlFrame.Copy"));
        this.printFrameItem = new JMenuItem(DisplayRes.getString("DrawingFrame.PrintFrame_menu_item"));
        this.saveFrameAsEPSItem = new JMenuItem(DisplayRes.getString("DrawingFrame.SaveFrameAsEPS_menu_item"));
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Print_menu_title"));
        this.fileMenu.add(this.readItem);
        this.fileMenu.add(this.saveAsItem);
        this.fileMenu.add(this.inspectItem);
        this.fileMenu.add(this.clearItem);
        this.fileMenu.add(jMenu);
        jMenu.add(this.printFrameItem);
        jMenu.add(this.saveFrameAsEPSItem);
        this.editMenu.add(this.copyItem);
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, MENU_SHORTCUT_KEY_MASK));
        this.copyItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlFrame.this.copy();
            }
        });
        this.saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, MENU_SHORTCUT_KEY_MASK));
        this.saveAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlFrame.this.saveXML();
            }
        });
        this.inspectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlFrame.this.inspectXML();
            }
        });
        this.readItem.setAccelerator(KeyStroke.getKeyStroke(76, MENU_SHORTCUT_KEY_MASK));
        this.readItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlFrame.this.loadXML((String)null);
            }
        });
        this.clearItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlFrame.this.xmlDefault = null;
            }
        });
        this.printFrameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintUtils.printComponent(ControlFrame.this);
            }
        });
        this.saveFrameAsEPSItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PrintUtils.saveComponentAsEPS(ControlFrame.this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.loadDisplayMenu();
        JMenu jMenu2 = new JMenu(ControlsRes.getString("ControlFrame.Help"));
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem(ControlsRes.getString("ControlFrame.About"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPRuntime.showAboutDialog(ControlFrame.this);
            }
        });
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(ControlsRes.getString("ControlFrame.System"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlUtils.showSystemProperties(true);
            }
        });
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(ControlsRes.getString("ControlFrame.Display_All_Frames"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.showDrawingAndTableFrames();
            }
        });
        jMenu2.add(jMenuItem3);
        jMenu2.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(ControlsRes.getString("ControlFrame.Message_Log"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog.getOSPLog().setVisible(true);
            }
        });
        jMenu2.add(jMenuItem4);
        this.logToFileItem = new JCheckBoxMenuItem(ControlsRes.getString("ControlFrame.Log_to_File"));
        this.logToFileItem.setSelected(false);
        this.logToFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                OSPLog.getOSPLog().setLogToFile(jCheckBoxMenuItem.isSelected());
            }
        });
        jMenu2.add(this.logToFileItem);
        this.validate();
    }

    protected JMenu loadDisplayMenu() {
        int n;
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        this.displayMenu = super.loadDisplayMenu();
        if (this.displayMenu == null) {
            this.displayMenu = new JMenu();
            this.displayMenu.setText(ControlsRes.getString("ControlFrame.Display"));
            jMenuBar.add(this.displayMenu);
        }
        this.languageMenu = new JMenu();
        this.languageMenu.setText(ControlsRes.getString("ControlFrame.Language"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                Locale[] localeArray = OSPRuntime.getInstalledLocales();
                for (int i = 0; i < localeArray.length; ++i) {
                    if (!string.equals(localeArray[i].getDisplayName())) continue;
                    ToolsRes.setLocale(localeArray[i]);
                    return;
                }
            }
        };
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        for (n = 0; n < localeArray.length; ++n) {
            this.languageItems[n] = new JRadioButtonMenuItem(localeArray[n].getDisplayName(localeArray[n]));
            this.languageItems[n].setActionCommand(localeArray[n].getDisplayName());
            this.languageItems[n].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n]);
            buttonGroup.add(this.languageItems[n]);
        }
        for (n = 0; n < localeArray.length; ++n) {
            if (!localeArray[n].getLanguage().equals(ToolsRes.getLanguage())) continue;
            this.languageItems[n].setSelected(true);
        }
        if (OSPRuntime.isAuthorMode() || !OSPRuntime.isLauncherMode()) {
            this.displayMenu.add(this.languageMenu);
        }
        JMenu jMenu = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
        this.displayMenu.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(ControlsRes.getString("ControlFrame.Increase_Font_Size"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelUp();
            }
        });
        jMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(ControlsRes.getString("ControlFrame.Decrease_Font_Size"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSizer.levelDown();
            }
        });
        jMenu.add(jMenuItem2);
        jMenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jMenuItem2.setEnabled(FontSizer.getLevel() > 0);
            }
        });
        return this.displayMenu;
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.createMenuBar();
    }

    public void save() {
        ControlUtils.saveToFile(this, this);
    }

    public void readParameters() {
        ControlUtils.loadParameters(this, this);
    }

    public void copy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void saveXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        if (jFileChooser == null) {
            return;
        }
        String string = jFileChooser.getDialogTitle();
        jFileChooser.setDialogTitle(ControlsRes.getString("ControlFrame.Save_XML_Data"));
        int n = jFileChooser.showSaveDialog(null);
        jFileChooser.setDialogTitle(string);
        if (n == 0) {
            int n2;
            File file = jFileChooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, ControlsRes.getString("ControlFrame.Replace_existing") + file.getName() + ControlsRes.getString("ControlFrame.question_mark"), ControlsRes.getString("ControlFrame.Replace_File"), 1)) != 0) {
                return;
            }
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string2 = file.getAbsolutePath();
            if (string2 == null || string2.trim().equals("")) {
                return;
            }
            int n3 = string2.toLowerCase().lastIndexOf(".xml");
            if (n3 != string2.length() - 4) {
                string2 = string2 + ".xml";
            }
            XMLControlElement xMLControlElement = new XMLControlElement(this.getOSPApp());
            xMLControlElement.write(string2);
        }
    }

    public void loadXML(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadXML(stringArray[i]);
            }
        }
    }

    public void loadXML(String string) {
        XMLControlElement xMLControlElement;
        if (string == null || string.trim().equals("")) {
            this.loadXML();
            return;
        }
        if ((class$org$opensourcephysics$controls$OSPApplication == null ? (class$org$opensourcephysics$controls$OSPApplication = ControlFrame.class$("org.opensourcephysics.controls.OSPApplication")) : class$org$opensourcephysics$controls$OSPApplication).isAssignableFrom((xMLControlElement = new XMLControlElement(string)).getObjectClass())) {
            this.xmlDefault = xMLControlElement;
            this.xmlDefault.loadObject(this.getOSPApp());
        } else {
            JOptionPane.showMessageDialog(this, "\"" + string + "\" is for " + xMLControlElement.getObjectClass() + ".", "Incorrect XML Object Type", 2);
        }
    }

    public void loadXML() {
        JFileChooser jFileChooser = OSPRuntime.getChooser();
        if (jFileChooser == null) {
            return;
        }
        String string = jFileChooser.getDialogTitle();
        jFileChooser.setDialogTitle(ControlsRes.getString("ControlFrame.Load_XML_Data"));
        int n = jFileChooser.showOpenDialog(null);
        jFileChooser.setDialogTitle(string);
        if (n == 0) {
            OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
            String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
            this.loadXML(string2);
        }
    }

    public void inspectXML() {
        XMLControlElement xMLControlElement = new XMLControlElement(this.getOSPApp());
        XMLTreePanel xMLTreePanel = new XMLTreePanel(xMLControlElement);
        JDialog jDialog = new JDialog((Frame)null, true);
        jDialog.setContentPane(xMLTreePanel);
        ((Component)jDialog).setSize(new Dimension(600, 300));
        ((Component)jDialog).setVisible(true);
    }

    protected OSPApplication getOSPApp() {
        if (this.ospApp == null) {
            this.ospApp = new OSPApplication(this, this.model);
        }
        return this.ospApp;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

