/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPControl;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.GUIUtils;

public class AnimationControl
extends OSPControl {
    String resetToolTipText = ControlsRes.ANIMATION_RESET_TIP;
    String initToolTipText = ControlsRes.ANIMATION_INIT_TIP;
    String startToolTipText = ControlsRes.ANIMATION_START_TIP;
    String stopToolTipText = ControlsRes.ANIMATION_STOP_TIP;
    String newToolTipText = ControlsRes.ANIMATION_NEW_TIP;
    String stepToolTipText = ControlsRes.ANIMATION_STEP_TIP;
    String initText = ControlsRes.ANIMATION_INIT;
    String startText = ControlsRes.ANIMATION_START;
    String stopText = ControlsRes.ANIMATION_STOP;
    String resetText = ControlsRes.ANIMATION_RESET;
    String newText = ControlsRes.ANIMATION_NEW;
    boolean stepModeEditing = true;
    JButton startBtn = new JButton(ControlsRes.ANIMATION_INIT);
    JButton stepBtn = new JButton(ControlsRes.ANIMATION_STEP);
    JButton resetBtn = new JButton(ControlsRes.ANIMATION_RESET);

    public AnimationControl(Animation animation) {
        super(animation);
        if (this.model != null) {
            String string = this.model.getClass().getName();
            this.setTitle(string.substring(1 + string.lastIndexOf(".")) + " Controller");
        }
        this.startBtn.addActionListener(new StartBtnListener());
        this.startBtn.setToolTipText(this.initToolTipText);
        this.stepBtn.addActionListener(new StepBtnListener());
        this.stepBtn.setToolTipText(this.stepToolTipText);
        this.resetBtn.addActionListener(new ResetBtnListener());
        this.resetBtn.setToolTipText(this.resetToolTipText);
        this.stepBtn.setEnabled(false);
        this.buttonPanel.add(this.startBtn);
        this.buttonPanel.add(this.stepBtn);
        this.buttonPanel.add(this.resetBtn);
        this.validate();
        this.pack();
    }

    protected void refreshGUI() {
        super.refreshGUI();
        this.resetToolTipText = ControlsRes.ANIMATION_RESET_TIP;
        this.initToolTipText = ControlsRes.ANIMATION_INIT_TIP;
        this.startToolTipText = ControlsRes.ANIMATION_START_TIP;
        this.stopToolTipText = ControlsRes.ANIMATION_STOP_TIP;
        this.newToolTipText = ControlsRes.ANIMATION_NEW_TIP;
        this.stepToolTipText = ControlsRes.ANIMATION_STEP_TIP;
        this.stepBtn.setText(ControlsRes.ANIMATION_STEP);
        this.stepBtn.setToolTipText(this.stepToolTipText);
        if (this.startBtn.getText().equals(this.startText)) {
            this.startBtn.setText(ControlsRes.ANIMATION_START);
            this.startBtn.setToolTipText(this.startToolTipText);
        } else if (this.startBtn.getText().equals(this.stopText)) {
            this.startBtn.setText(ControlsRes.ANIMATION_STOP);
            this.startBtn.setToolTipText(this.stopToolTipText);
        } else {
            this.startBtn.setText(ControlsRes.ANIMATION_INIT);
            this.startBtn.setToolTipText(this.initToolTipText);
        }
        if (this.resetBtn.getText().equals(this.newText)) {
            this.resetBtn.setText(ControlsRes.ANIMATION_NEW);
            this.resetBtn.setToolTipText(this.newToolTipText);
        } else {
            this.resetBtn.setText(ControlsRes.ANIMATION_RESET);
            this.resetBtn.setToolTipText(this.resetToolTipText);
        }
        this.initText = ControlsRes.ANIMATION_INIT;
        this.startText = ControlsRes.ANIMATION_START;
        this.resetText = ControlsRes.ANIMATION_RESET;
        this.stopText = ControlsRes.ANIMATION_STOP;
        this.newText = ControlsRes.ANIMATION_NEW;
    }

    public void dispose() {
        if (this.model instanceof AbstractAnimation) {
            ((AbstractAnimation)this.model).animationThread = null;
        }
        super.dispose();
    }

    public void calculationDone(final String string) {
        if (this.model instanceof Animation) {
            ((Animation)this.model).stopAnimation();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                AnimationControl.this.startBtnActionPerformed(new ActionEvent(this, 0, AnimationControl.this.stopText));
                AnimationControl.this.resetBtnActionPerformed(new ActionEvent(this, 0, AnimationControl.this.newText));
                AnimationControl.this.resetBtn.setEnabled(true);
                GUIUtils.enableMenubars(true);
                if (string != null) {
                    AnimationControl.this.println(string);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void startBtnActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.initText)) {
            this.stepBtn.setEnabled(true);
            this.startBtn.setText(this.startText);
            this.startBtn.setToolTipText(this.startToolTipText);
            this.resetBtn.setText(this.newText);
            this.resetBtn.setToolTipText(this.newToolTipText);
            this.resetBtn.setEnabled(true);
            this.readItem.setEnabled(this.stepModeEditing);
            this.table.setEnabled(this.stepModeEditing);
            this.messageTextArea.setEditable(false);
            GUIUtils.clearDrawingFrameData(false);
            if (this.model == null) {
                this.println("This AnimationControl's model is null.");
            } else {
                ((Animation)this.model).initializeAnimation();
            }
            GUIUtils.showDrawingAndTableFrames();
        } else if (actionEvent.getActionCommand().equals(this.startText)) {
            this.setCustomButtonsEnabled(false);
            this.startBtn.setText(this.stopText);
            this.startBtn.setToolTipText(this.stopToolTipText);
            this.stepBtn.setEnabled(false);
            this.resetBtn.setEnabled(false);
            this.readItem.setEnabled(false);
            this.table.setEnabled(false);
            GUIUtils.enableMenubars(false);
            ((Animation)this.model).startAnimation();
        } else {
            this.startBtn.setText(this.startText);
            this.setCustomButtonsEnabled(true);
            this.startBtn.setToolTipText(this.startToolTipText);
            this.stepBtn.setEnabled(true);
            this.resetBtn.setEnabled(true);
            GUIUtils.enableMenubars(true);
            this.readItem.setEnabled(this.stepModeEditing);
            this.table.setEnabled(this.stepModeEditing);
            ((Animation)this.model).stopAnimation();
        }
    }

    void resetBtnActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.resetText)) {
            GUIUtils.clearDrawingFrameData(true);
            if (this.model == null) {
                this.println("This AnimationControl's model is null.");
                return;
            }
            ((Animation)this.model).resetAnimation();
            if (this.xmlDefault != null) {
                this.xmlDefault.loadObject(this.getOSPApp());
            }
            this.table.refresh();
        } else {
            this.startBtn.setText(this.initText);
            this.startBtn.setToolTipText(this.initToolTipText);
            this.resetBtn.setText(this.resetText);
            this.resetBtn.setToolTipText(this.resetToolTipText);
            this.stepBtn.setEnabled(false);
            this.readItem.setEnabled(true);
            this.table.setEnabled(true);
            this.messageTextArea.setEditable(true);
            this.setCustomButtonsEnabled(true);
        }
    }

    void stepBtnActionPerformed(ActionEvent actionEvent) {
        ((Animation)this.model).stepAnimation();
    }

    private void setCustomButtonsEnabled(boolean bl) {
        if (this.customButtons != null) {
            Iterator iterator = ((AbstractList)this.customButtons).iterator();
            while (iterator.hasNext()) {
                ((JButton)iterator.next()).setEnabled(bl);
            }
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new AnimationControlLoader();
    }

    public static AnimationControl createApp(Animation animation) {
        AnimationControl animationControl = new AnimationControl(animation);
        animation.setControl(animationControl);
        return animationControl;
    }

    public static AnimationControl createApp(Animation animation, String[] stringArray) {
        AnimationControl animationControl = AnimationControl.createApp(animation);
        animationControl.loadXML(stringArray);
        return animationControl;
    }

    static class AnimationControlLoader
    extends OSPControl.OSPControlLoader {
        AnimationControlLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            AnimationControl animationControl = (AnimationControl)object;
            if (animationControl.startBtn.getText().equals(animationControl.stopText)) {
                animationControl.startBtn.doClick();
            }
            xMLControl.setValue("initialize_mode", animationControl.startBtn.getText().equals(animationControl.initText));
            super.saveObject(xMLControl, object);
        }

        public Object createObject(XMLControl xMLControl) {
            return new AnimationControl(null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            AnimationControl animationControl = (AnimationControl)object;
            if (animationControl.startBtn.getText().equals(animationControl.stopText)) {
                animationControl.startBtn.doClick();
            }
            boolean bl = xMLControl.getBoolean("initialize_mode");
            xMLControl.setValue("initialize_mode", null);
            super.loadObject(xMLControl, object);
            if (bl) {
                xMLControl.setValue("initialize_mode", true);
            }
            if (bl && animationControl.startBtn.getText().equals(animationControl.startText)) {
                animationControl.resetBtn.doClick();
            }
            if (!bl && animationControl.startBtn.getText().equals(animationControl.initText)) {
                animationControl.startBtn.doClick();
            }
            animationControl.clearMessages();
            return object;
        }
    }

    class StepBtnListener
    implements ActionListener {
        StepBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnimationControl.this.stepBtnActionPerformed(actionEvent);
        }
    }

    class ResetBtnListener
    implements ActionListener {
        ResetBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnimationControl.this.resetBtnActionPerformed(actionEvent);
        }
    }

    class StartBtnListener
    implements ActionListener {
        StartBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AnimationControl.this.startBtnActionPerformed(actionEvent);
        }
    }
}

