/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.GUIUtils;

public abstract class AbstractSimulation
extends AbstractAnimation
implements Simulation {
    protected SimControl control;
    protected boolean showStepsPerDisplay = false;
    protected int stepsPerDisplay = 1;
    protected int stepCounter = 0;

    public void setControl(Control control) {
        this.control = control instanceof SimControl ? (SimulationControl)control : new ShadowControl(control);
        ((AbstractAnimation)this).control = control;
        if (control != null) {
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void startRunning() {
    }

    public void stopRunning() {
    }

    public void startAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.start();
        this.startRunning();
        super.startAnimation();
    }

    public final void startSimulation() {
        this.startAnimation();
    }

    public void start() {
    }

    public void stopAnimation() {
        super.stopAnimation();
        this.stopRunning();
        this.stop();
    }

    public final void stopSimulation() {
        this.stopAnimation();
    }

    public void stop() {
    }

    public final void stepAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.startRunning();
        super.stepAnimation();
        ++this.stepCounter;
        this.stopRunning();
        GUIUtils.repaintAnimatedFrames();
    }

    public void initializeAnimation() {
        if (this.control == null) {
            return;
        }
        super.initializeAnimation();
        this.initialize();
        this.stepCounter = 0;
    }

    public int getStepCounter() {
        return this.stepCounter;
    }

    public void initialize() {
    }

    public void resetAnimation() {
        if (this.control == null) {
            return;
        }
        super.resetAnimation();
        this.stepsPerDisplay = 1;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
        this.reset();
    }

    public void enableStepsPerDisplay(boolean bl) {
        this.showStepsPerDisplay = bl;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        } else {
            this.control.removeParameter("steps per display");
        }
    }

    public void setStepsPerDisplay(int n) {
        this.stepsPerDisplay = Math.max(n, 1);
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
    }

    public int getStepsPerDisplay() {
        return this.stepsPerDisplay;
    }

    public void reset() {
    }

    public void run() {
        GUIUtils.setAnimatedFrameIgnoreRepaint(true);
        long l = this.delayTime;
        while (this.animationThread == Thread.currentThread()) {
            long l2 = System.currentTimeMillis();
            for (int i = 0; i < this.stepsPerDisplay; ++i) {
                this.doStep();
                ++this.stepCounter;
                if (this.animationThread != Thread.currentThread()) break;
                Thread.yield();
            }
            GUIUtils.renderAnimatedFrames();
            l = Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - l2));
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        GUIUtils.setAnimatedFrameIgnoreRepaint(false);
    }

    private class ShadowControl
    implements SimControl {
        Control control;

        ShadowControl(Control control) {
            this.control = control;
        }

        public void setAdjustableValue(String string, boolean bl) {
            this.control.setValue(string, bl);
        }

        public void setAdjustableValue(String string, double d) {
            this.control.setValue(string, d);
        }

        public void setAdjustableValue(String string, int n) {
            this.control.setValue(string, n);
        }

        public void setAdjustableValue(String string, Object object) {
            this.control.setValue(string, object);
        }

        public void removeParameter(String string) {
        }

        public void setLockValues(boolean bl) {
            this.control.setLockValues(bl);
        }

        public void setValue(String string, Object object) {
            this.control.setValue(string, object);
        }

        public void setValue(String string, double d) {
            this.control.setValue(string, d);
        }

        public void setValue(String string, int n) {
            this.control.setValue(string, n);
        }

        public void setValue(String string, boolean bl) {
            this.control.setValue(string, bl);
        }

        public int getInt(String string) {
            return this.control.getInt(string);
        }

        public double getDouble(String string) {
            return this.control.getDouble(string);
        }

        public Object getObject(String string) {
            return this.control.getObject(string);
        }

        public String getString(String string) {
            return this.control.getString(string);
        }

        public boolean getBoolean(String string) {
            return this.control.getBoolean(string);
        }

        public Collection getPropertyNames() {
            return this.control.getPropertyNames();
        }

        public void println(String string) {
            this.control.println(string);
        }

        public void println() {
            this.control.println();
        }

        public void print(String string) {
            this.control.print(string);
        }

        public void clearMessages() {
            this.control.clearMessages();
        }

        public void clearValues() {
            this.control.clearValues();
        }

        public void calculationDone(String string) {
            this.control.calculationDone(string);
        }

        public void setParameterToFixed(String string, boolean bl) {
        }
    }
}

