/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.analysis;

import java.awt.Color;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.numerics.FFTReal;

public class FourierSinCosAnalysis
implements Data {
    static final double PI2 = Math.PI * 2;
    FFTReal fft = new FFTReal();
    double[] fftData;
    double[] omega;
    double[] freqs;
    private double[] cosVec;
    private double[] sinVec;
    private double[] gutterVec;
    ComplexDataset[] complexDatasets = new ComplexDataset[1];
    Dataset[] realDatasets = new Dataset[3];
    boolean radians = false;

    public double[] doAnalysis(double[] dArray, double[] dArray2, int n) {
        int n2;
        this.fftData = new double[dArray2.length + 2 * n];
        this.gutterVec = new double[n];
        System.arraycopy(dArray2, 0, this.fftData, n, dArray2.length);
        this.fft.transform(this.fftData);
        double d = dArray[1] - dArray[0];
        double d2 = dArray[0] - (double)n * d;
        double d3 = dArray[dArray.length - 1] + (double)(n + 1) * d;
        this.omega = this.fft.getNaturalOmega(d2, d3);
        this.freqs = this.fft.getNaturalFreq(d2, d3);
        this.cosVec = new double[this.omega.length];
        this.sinVec = new double[this.omega.length];
        double d4 = 2.0 / (double)this.fftData.length;
        int n3 = this.omega.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.cosVec[n2] = d4 * Math.cos(this.omega[n2] * d2);
            this.sinVec[n2] = d4 * Math.sin(this.omega[n2] * d2);
        }
        this.cosVec[0] = this.cosVec[0] * 0.5;
        this.sinVec[0] = this.sinVec[0] * 0.5;
        n3 = this.omega.length;
        for (n2 = 0; n2 < n3; ++n2) {
            double d5 = this.fftData[2 * n2];
            double d6 = this.fftData[2 * n2 + 1];
            this.fftData[2 * n2] = d5 * this.cosVec[n2] + d6 * this.sinVec[n2];
            this.fftData[2 * n2 + 1] = -d6 * this.cosVec[n2] + d5 * this.sinVec[n2];
        }
        return this.fftData;
    }

    public double[] repeatAnalysis(double[] dArray) {
        double d;
        double d2;
        int n;
        if (this.fftData == null) {
            n = dArray.length;
            double[] dArray2 = new double[n];
            d2 = 0.0;
            d = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d2;
                d2 += d;
            }
            this.doAnalysis(dArray2, dArray, 0);
        }
        System.arraycopy(this.gutterVec, 0, this.fftData, 0, this.gutterVec.length);
        System.arraycopy(this.gutterVec, 0, this.fftData, this.fftData.length - 1 - this.gutterVec.length, this.gutterVec.length);
        System.arraycopy(dArray, 0, this.fftData, this.gutterVec.length, dArray.length);
        this.fft.transform(this.fftData);
        int n2 = this.omega.length;
        for (n = 0; n < n2; ++n) {
            d2 = this.fftData[2 * n];
            d = this.fftData[2 * n + 1];
            this.fftData[2 * n] = d2 * this.cosVec[n] + d * this.sinVec[n];
            this.fftData[2 * n + 1] = d * this.cosVec[n] - d2 * this.sinVec[n];
        }
        return this.fftData;
    }

    public double[] getNaturalOmega() {
        return this.omega;
    }

    public double[] getNaturalFreq() {
        return this.freqs;
    }

    public void useRadians(boolean bl) {
        this.radians = bl;
    }

    public boolean isRadians() {
        return this.radians;
    }

    public ComplexDataset[] getComplexDatasets() {
        return null;
    }

    public Dataset[] getDatasets() {
        if (this.fftData == null) {
            return null;
        }
        if (this.realDatasets[0] == null) {
            this.realDatasets[0] = new Dataset();
            this.realDatasets[0].setXYColumnNames("frequency", "power", "Power Spectrum");
            this.realDatasets[0].setLineColor(Color.BLACK);
            this.realDatasets[1] = new Dataset();
            this.realDatasets[1].setXYColumnNames("frequency", "cos", "Cosine Coefficients");
            this.realDatasets[1].setLineColor(Color.RED);
            this.realDatasets[2] = new Dataset();
            this.realDatasets[2].setXYColumnNames("frequency", "sin", "Sine Coefficients");
            this.realDatasets[2].setLineColor(Color.BLUE);
        } else {
            this.realDatasets[0].clear();
            this.realDatasets[1].clear();
            this.realDatasets[2].clear();
        }
        if (this.radians) {
            int n = this.omega.length;
            for (int i = 0; i < n; ++i) {
                double d = this.fftData[2 * i];
                double d2 = this.fftData[2 * i + 1];
                this.realDatasets[0].append(this.omega[i], d2 * d2 + d * d);
                this.realDatasets[1].append(this.omega[i], d2);
                this.realDatasets[2].append(this.omega[i], d);
            }
        } else {
            int n = this.freqs.length;
            for (int i = 0; i < n; ++i) {
                double d = this.fftData[2 * i];
                double d3 = this.fftData[2 * i + 1];
                this.realDatasets[0].append(this.freqs[i], d * d + d3 * d3);
                this.realDatasets[1].append(this.freqs[i], d);
                this.realDatasets[2].append(this.freqs[i], d3);
            }
        }
        return this.realDatasets;
    }

    public double[][] getData() {
        if (this.fftData == null) {
            return null;
        }
        double[][] dArrayArray = new double[4][];
        int n = this.fftData.length / 2;
        dArrayArray[1] = new double[n];
        dArrayArray[2] = new double[n];
        dArrayArray[3] = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.fftData[2 * i];
            double d2 = this.fftData[2 * i + 1];
            dArrayArray[1][i] = d2 * d2 + d * d;
            dArrayArray[2][i] = d;
            dArrayArray[3][i] = d2;
        }
        dArrayArray[0] = this.radians ? this.omega : this.freqs;
        return dArrayArray;
    }

    public double[][][] getDataXYZ() {
        return null;
    }
}

