/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.analysis;

import java.awt.Color;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.numerics.FFT;

public class FourierAnalysis
implements Data {
    static final double PI2 = Math.PI * 2;
    FFT fft = new FFT();
    double[] fftData;
    double[] omega;
    double[] freqs;
    double[] cosVec;
    double[] sinVec;
    double[] gutterVec;
    ComplexDataset[] complexDatasets = new ComplexDataset[1];
    Dataset[] realDatasets = new Dataset[2];
    boolean radians = false;

    public double[] doAnalysis(double[] dArray, double[] dArray2, int n) {
        int n2;
        this.fftData = new double[dArray2.length + 4 * n];
        this.gutterVec = new double[2 * n];
        System.arraycopy(dArray2, 0, this.fftData, 2 * n, dArray2.length);
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double d = dArray[1] - dArray[0];
        double d2 = dArray[0] - (double)n * d;
        double d3 = dArray[dArray.length - 1] + (double)(n + 1) * d;
        this.omega = this.fft.getNaturalOmega(d2, d3);
        this.freqs = this.fft.getNaturalFreq(d2, d3);
        this.cosVec = new double[this.omega.length];
        this.sinVec = new double[this.omega.length];
        int n3 = this.omega.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.cosVec[n2] = Math.cos(this.omega[n2] * d2);
            this.sinVec[n2] = Math.sin(this.omega[n2] * d2);
        }
        n3 = this.omega.length;
        for (n2 = 0; n2 < n3; ++n2) {
            double d4 = this.fftData[2 * n2];
            double d5 = this.fftData[2 * n2 + 1];
            this.fftData[2 * n2] = d4 * this.cosVec[n2] + d5 * this.sinVec[n2];
            this.fftData[2 * n2 + 1] = d5 * this.cosVec[n2] - d4 * this.sinVec[n2];
        }
        return this.fftData;
    }

    public double[] repeatAnalysis(double[] dArray) {
        double d;
        double d2;
        int n;
        if (this.fftData == null) {
            n = dArray.length;
            double[] dArray2 = new double[n];
            d2 = 0.0;
            d = 1.0 / (double)n;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = d2;
                d2 += d;
            }
            this.doAnalysis(dArray2, dArray, 0);
        }
        System.arraycopy(this.gutterVec, 0, this.fftData, 0, this.gutterVec.length);
        System.arraycopy(this.gutterVec, 0, this.fftData, this.fftData.length - 1 - this.gutterVec.length, this.gutterVec.length);
        System.arraycopy(dArray, 0, this.fftData, this.gutterVec.length, dArray.length);
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        int n2 = this.omega.length;
        for (n = 0; n < n2; ++n) {
            d2 = this.fftData[2 * n];
            d = this.fftData[2 * n + 1];
            this.fftData[2 * n] = d2 * this.cosVec[n] + d * this.sinVec[n];
            this.fftData[2 * n + 1] = d * this.cosVec[n] - d2 * this.sinVec[n];
        }
        return this.fftData;
    }

    public double[] getNaturalOmega() {
        return this.omega;
    }

    public double[] getNaturalFreq() {
        return this.freqs;
    }

    public void useRadians(boolean bl) {
        this.radians = bl;
    }

    public boolean isRadians() {
        return this.radians;
    }

    public ComplexDataset[] getComplexDatasets() {
        if (this.fftData == null) {
            return null;
        }
        if (this.complexDatasets[0] == null) {
            this.complexDatasets[0] = new ComplexDataset();
            this.complexDatasets[0].setXYColumnNames("frequency", "re", "im");
        } else {
            this.complexDatasets[0].clear();
        }
        if (this.radians) {
            this.complexDatasets[0].append(this.omega, this.fftData);
        } else {
            this.complexDatasets[0].append(this.freqs, this.fftData);
        }
        return this.complexDatasets;
    }

    public Dataset[] getDatasets() {
        if (this.fftData == null) {
            return null;
        }
        if (this.realDatasets[0] == null) {
            this.realDatasets[0] = new Dataset();
            this.realDatasets[0].setXYColumnNames("frequency", "re", "Real Coefficients");
            this.realDatasets[0].setLineColor(Color.RED);
            this.realDatasets[1] = new Dataset();
            this.realDatasets[1].setXYColumnNames("frequency", "im", "Imaginary Coefficients");
            this.realDatasets[1].setLineColor(Color.BLUE);
        } else {
            this.realDatasets[0].clear();
            this.realDatasets[1].clear();
        }
        if (this.radians) {
            int n = this.omega.length;
            for (int i = 0; i < n; ++i) {
                double d = this.fftData[2 * i];
                double d2 = this.fftData[2 * i + 1];
                this.realDatasets[0].append(this.omega[i], d);
                this.realDatasets[1].append(this.omega[i], d2);
            }
        } else {
            int n = this.freqs.length;
            for (int i = 0; i < n; ++i) {
                double d = this.fftData[2 * i];
                double d3 = this.fftData[2 * i + 1];
                this.realDatasets[0].append(this.freqs[i], d);
                this.realDatasets[1].append(this.freqs[i], d3);
            }
        }
        return this.realDatasets;
    }

    public double[][] getData() {
        if (this.fftData == null) {
            return null;
        }
        double[][] dArrayArray = new double[3][];
        int n = this.fftData.length / 2;
        dArrayArray[1] = new double[n];
        dArrayArray[2] = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.fftData[2 * i];
            double d2 = this.fftData[2 * i + 1];
            dArrayArray[1][i] = d;
            dArrayArray[2][i] = d2;
        }
        dArrayArray[0] = this.radians ? this.omega : this.freqs;
        return dArrayArray;
    }

    public double[][][] getDataXYZ() {
        return null;
    }
}

