# This script computes the MEAN in zonal statistics for many rasters for polygon vector data. 

import glob, os, qgis.analysis
from qgis.analysis import QgsZonalStatistics

vectorlayer = QgsVectorLayer('PATH TO .SHP HERE', 'zonepolygons', "ogr")  # Insert path to vector file here.
rasterfolder = 'PATH TO RASTER FOLDER HERE' # Insert path to folder with raster data here (all raster must be in *.tif format)
os.chdir(rasterfolder)
for key in glob.glob("*.tif"):
    
    fileInfo = QFileInfo(rasterfolder+key)
    path = fileInfo.filePath()
    baseName = fileInfo.baseName()
    lyr = QgsRasterLayer(path, baseName)
    
    band = 1
    zoneStat = QgsZonalStatistics (vectorlayer, lyr,key[:-3], band, QgsZonalStatistics.Mean)
    print(zoneStat)
    zoneStat.calculateStatistics(None)
print('done')

