function [penm] = sdp_define(sdpdata)
% define penm structure for Linear SPD based on 'sdpdata' structure
% typically got from sparse SDPA files by calling
%      sdpdata=readsdpa(filename);
% Elements of the structure
%   name ... name of the problem (filename of SDPA file if the reader is used)
%   Nx ..... number of primal variables
%   Na ..... number of linear matrix inequalities (or diagonal blocks of the
%            matrix constraint)
%   Ng ..... number of linear inequalitites
%   B ...... matrix defining the linear inequality constraints Bx<=d
%            dimension Ng x Nx
%   d ...... rhs for linear constraints
%   c ...... dim (Nx,1), coefficients of the linear objective function
%   NaDims . vector of sizes of matrix constraints (diagonal blocks)
%   A ...... cell array (matrix) of A{k,l} for k=1,...,Na matrix constraint
%            for l=1 ~ absolute term, l=2..Nx+1 coeficient matrices
%            (some of them might be empty)
%   Adep ... rather create here vvv !!!
%
% See also readsdpa

% This file is a part of PENLAB package distributed under GPLv3 license
% Copyright (c) 2013 by  J. Fiala, M. Kocvara, M. Stingl
% Last Modified: 27 Nov 2013

  penm = [];

  if (isfield(sdpdata,'name'))
    penm.probname=sdpdata.name;
  end
  penm.comment = 'Structure PENM generated by sdp_define()';

  % keep the whole structure
  penm.userdata=sdpdata;
  penm.Adep = sdpdata.Adep;

  penm.Nx=sdpdata.Nx;

  penm.NgLIN=sdpdata.Ng;  %length(sdpdata.d);
  penm.lbg = sdpdata.d;

  penm.NALIN=sdpdata.Na;
  % let's make it negative semidefinite
  penm.ubA=zeros(sdpdata.Na,1);

  penm.objfun = @sdp_objfun;
  penm.objgrad = @sdp_objgrad;
  penm.objhess = @sdp_objhess;

  penm.confun = @sdp_confun;
  penm.congrad = @sdp_congrad;
  %penm.conhess = @sdp_conhess;  not needed because all linear

  penm.mconfun = @sdp_mconfun;
  penm.mcongrad = @sdp_mcongrad;
  % hessian not needed as linear


