function [penm] = tto_define(par)
% define penm structure for the TTO problem

nx = par.nx; ny = par.ny;
A = par.A; IA = par.IA; nelem=par.nelem; nnod=par.nnod;
 nloads = par.nloads;
 ny2 = ny/2; nelem2 = nelem/2; nnod2 = 2*nx*ny2; nnodi = 2*nx;
 n1 = nnod ; m = nelem;
  volume = nelem/3;
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
lb = 1;
for ie=1:nelem
    len = IA(ie);
    %clear ss;
    ss = sparse(A(lb:lb+len-1),A(lb+len:lb+2*len-1),A(lb+2*len:lb+3*len-1),nnod,nnod);
    hel = triu(ss) + tril(ss)' - diag(diag(ss));
    ss = hel +hel' - diag(diag(hel)) ;
    AA{1,ie+1} = [0 sparse(1,n1); sparse(n1,1) ss];
    lb = lb + 3*len;
end
  
  
  AA{1,m+2} = sparse(n1+1,n1+1);
  AA{1,m+2}(1,1) = 1;
  
  for k=1:nloads
      ff = par.ff{k};
      AA{k,1} = -[0 -ff'; -ff sparse(n1,n1)];
  end
  
  sdpdata.Nx = m+1;% ..... number of primal variables
  sdpdata.Na = nloads;% ..... number of linear matrix inequalities 
  sdpdata.Ng = 1;% ..... number of linear inequalitites
  sdpdata.c = [zeros(m,1);1];% ... dim (Nx,1), coefficients of the linear objective function
  sdpdata.NaDims = [n1+1];% . vector of sizes of matrix constraints (diagonal blocks)
  sdpdata.A = AA;
  sdpdata.Adep = 1:m+1; ... rather create here vvv !!!
  clear A;
  
  penm = [];

%   if (isfield(sdpdata,'name'))
%     penm.probname=sdpdata.name;
%   end
%   penm.comment = 'Structure PENM generated by sdp_define()';

  % keep the whole structure
  penm.userdata=sdpdata;

  penm.Nx=sdpdata.Nx; 
  penm.lbx=[zeros(m,1);-Inf];
  %penm.ubx=[1.7.*ones(m,1);Inf];
    penm.ubx=[1.0.*ones(m,1);Inf];

  penm.NgLIN=sdpdata.Ng;  %length(sdpdata.d);
  penm.ubg = [volume];

  penm.NALIN=sdpdata.Na;
  % let's make it negative semidefinite
  penm.ubA=zeros(sdpdata.Na,1);

  penm.objfun = @tto_objfun;
  penm.objgrad = @tto_objgrad;
  penm.objhess = @tto_objhess;

  penm.confun = @tto_confun;
  penm.congrad = @tto_congrad;
  %penm.conhess = @sdp_conhess;  not needed because all linear

  penm.mconfun = @tto_mconfun;
  penm.mcongrad = @tto_mcongrad;
  % hessian not needed as linear


