function [penm] = tto_define(par)
%
% define penm structure for the TTO problem with buckling constraints

% This file is a part of PENLAB package distributed under GPLv3 license
% Copyright (c) 2013 by  J. Fiala, M. Kocvara, M. Stingl
% Last Modified: 27 Nov 2013
   
  m=par.m; n=par.n; n1=par.n1; BI=par.BI; xy=par.xy;
  maska=par.maska; ijk=par.ijk;
  
  BI = sparse(BI(:,maska));
  par.BI = BI;
  
  par.f=par.f;
  ff=par.f; 
  
  % PARAMETERS TO BE CHANGED MANUALLY
  compl = 1.0; par.cmp=compl;
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
  len = zeros(m,1);
  for i=1:m
      x1=xy(ijk(i,2)/2,1); y1=xy(ijk(i,2)/2,2);
      x2=xy(ijk(i,4)/2,1); y2=xy(ijk(i,4)/2,2);
      len(i,1)=sqrt((x1-x2)^2 + (y1-y2)^2);
  end
  %par.len = len;
  
  for i=1:m
    Ahelp = BI(i,:)'*BI(i,:);
    %A{1,i+1} = [0 sparse(1,n1); sparse(n1,1) Ahelp(maska,maska)];
    A{1,i+1} = Ahelp;
  end
  A{1,1} = [compl -ff'; -ff sparse(n1,n1)];
  
  sdpdata.Nx = m;% ..... number of primal variables
  sdpdata.Na = 2;% ..... number of linear matrix inequalities 
  sdpdata.Ng = 0;% ..... number of linear inequalitites
  sdpdata.c = ones(m,1);% ...... dim (Nx,1), coefficients of the linear objective function
  sdpdata.NaDims = [n1];% . vector of sizes of matrix constraints (diagonal blocks)
  sdpdata.A = A;
  sdpdata.Adep = [1:m,1:m]; ... rather create here vvv !!!
  clear A;
  sdpdata.par = par;
  
  penm = [];

%   if (isfield(sdpdata,'name'))
%     penm.probname=sdpdata.name;
%   end
%   penm.comment = 'Structure PENM generated by sdp_define()';

  % keep the whole structure
  penm.userdata=sdpdata;

  penm.Nx=sdpdata.Nx; 
  penm.lbx=zeros(m,1);
  penm.lbxbar = 1:m;
  penm.xinit=10*ones(m,1);

  penm.NgLIN=sdpdata.Ng;  %length(sdpdata.d);

  penm.NALIN=1;
  penm.NANLN=1;

  penm.lbA=zeros(penm.NALIN+penm.NANLN,1);

  penm.objfun = @tto_objfun;
  penm.objgrad = @tto_objgrad;
  penm.objhess = @tto_objhess;

  %penm.confun = @tto_confun;
  %penm.congrad = @tto_congrad;
  %penm.conhess = @sdp_conhess;  not needed because all linear

  penm.mconfun = @tto_mconfun;
  penm.mcongrad = @tto_mcongrad;
  penm.mconhess = @tto_mconhess;
  % hessian not needed as linear
  %penm.opts.max_inner_iter=300;
  %penm.opts.uinit=1000;
%penm.opts.outlev=2;
%penm.opts.penalty_update=.7;
%penm.opts.mmlt_update=.7;
%penm.opts.inner_stop_limit=1e-3;
%penm.opts.penalty_update=.7;
%penm.opts.usebarrier=1;
penm.opts.max_outer_iter=20;

