function test_lwr_1D
% test for 1D data set; due to globally optimized distance metric,
% one can observe overfitting in the flat parts of the function
n = 100;

% a random training set
X = rand(n,1);
Y = X - sin(2*pi*X.^3).*cos(2*pi*X.^3).*exp(X.^4) + randn(n,1)*0.1;

% a systematic test set
Xt = (0:.01:1)';
Yt = Xt - sin(2*pi*Xt.^3).*cos(2*pi*Xt.^3).*exp(Xt.^4);

% find the optimal distance metric by cross validation
Dmin = 10;
Dmax = 10000;
n_iter = 50;
for j=0:n_iter,
	D = Dmin-1 + exp(log(Dmax-(Dmin-1))/n_iter*j);
	mse_cv = 0;
	for i=1:n,
		XX=X;
		YY=Y;
		XX(i)=[];
		YY(i)=[];
		[beta,yq]=lwr(XX,YY,D,X(i)');
		mse_cv = mse_cv+(Y(i)-yq)^2;
	end
	mse_cv = mse_cv/n;
	R(j+1,:)=[D,mse_cv];
	disp(sprintf('%3d: D=%f mse_cv=%f',j,D,mse_cv));
end
[val,ind] = min(R(:,2));
D = R(ind,1);

% create the final LWR fit
Yp = zeros(size(Yt));
for i=1:length(Xt),
	[beta,yq]=lwr(X,Y,D,Xt(i)');
	Yp(i,1) = yq;
end

figure(1);
plot(X,Y,'*',Xt,[Yt Yp]);
title(sprintf('Optimial D=%f',D));
figure(2);
plot(R(:,1),R(:,2));
