/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DHFactor {
    ElementList results;

    public DHFactor(String string) {
        System.out.println("In DHFactor");
        this.results = DHFactor.parseString(string);
        System.out.println("In DHFactor, parseString is done");
        if (!this.isValid()) {
            System.out.println("DHFactor: error: Incomplete factorization, no DH equivalent found");
        }
    }

    private String angle(Element element) {
        return this.angle(element.constant);
    }

    public String toString() {
        return this.results.toString();
    }

    public String display() {
        return this.results.toString();
    }

    private String angle(int n) {
        if (n == 0) {
            return "0";
        }
        if (n == 90) {
            return "pi/2";
        }
        if (n == -90) {
            return "-pi/2";
        }
        throw new IllegalArgumentException("bad transform angle");
    }

    private String el2matlab(int n, int n2) {
        String string = "";
        block8: for (int i = n; i < n2; ++i) {
            Element element = (Element)this.results.get(i);
            if (string.length() > 0) {
                string = string + "*";
            }
            switch (element.type) {
                case 3: {
                    string = string + "trotx(" + this.angle(element) + ")";
                    continue block8;
                }
                case 4: {
                    string = string + "troty(" + this.angle(element) + ")";
                    continue block8;
                }
                case 5: {
                    string = string + "trotz(" + this.angle(element) + ")";
                    continue block8;
                }
                case 0: {
                    string = string + "transl(" + element.symconst + ",0,0)";
                    continue block8;
                }
                case 1: {
                    string = string + "transl(0, " + element.symconst + ",0)";
                    continue block8;
                }
                case 2: {
                    string = string + "transl(0,0," + element.symconst + ")";
                }
            }
        }
        if (string.length() == 0) {
            string = "eye(4,4)";
        }
        return string;
    }

    public String dh() {
        String string = "[";
        for (int i = 0; i < this.results.size(); ++i) {
            String string2;
            String string3;
            Element element = (Element)this.results.get(i);
            if (element.type != 6) continue;
            if (element.prismatic == 1) {
                string3 = "0";
                string2 = this.angle(element.theta);
            } else {
                string2 = "0";
                string3 = element.D == null ? "0" : element.D;
            }
            string = string + string2;
            string = string + ", ";
            string = string + string3;
            string = string + ", ";
            string = string + (element.A == null ? "0" : element.A);
            string = string + ", ";
            string = string + this.angle(element.alpha);
            string = string + ", " + element.prismatic;
            string = string + "; ";
        }
        string = string + "]";
        return string;
    }

    public boolean isValid() {
        int n = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            Element element = (Element)this.results.get(i);
            if (element.type != 6) continue;
            if (n >= 0 && i - n > 1) {
                return false;
            }
            n = i;
        }
        return true;
    }

    public String offset() {
        String string = "[";
        for (int i = 0; i < this.results.size(); ++i) {
            Element element = (Element)this.results.get(i);
            if (element.type != 6) continue;
            string = string + this.angle(element.offset) + " ";
        }
        string = string + "]";
        return string;
    }

    public String base() {
        for (int i = 0; i < this.results.size(); ++i) {
            Element element = (Element)this.results.get(i);
            if (element.type != 6 && element.type != 7) continue;
            return this.el2matlab(0, i);
        }
        return "eye(4,4)";
    }

    public String tool() {
        for (int i = this.results.size() - 1; i >= 0; --i) {
            Element element = (Element)this.results.get(i);
            if (element.type != 6 && element.type != 7) continue;
            return this.el2matlab(i, this.results.size());
        }
        return "eye(4,4)";
    }

    public String command(String string) {
        if (this.isValid()) {
            return "SerialLink(" + this.dh() + ", 'name', '" + string + "', 'base', " + this.base() + ", 'tool', " + this.tool() + ", 'offset', " + this.offset() + ")";
        }
        return "error('incompletely factored transform string')";
    }

    public static ElementList parseFile(String string) {
        try {
            File file = new File(string);
            if (!file.canRead() || !file.isFile()) {
                throw new IOException("dh: file access/type error");
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            return DHFactor.parseString(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        return null;
    }

    public static ElementList parseStdin() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = bufferedReader.readLine();
            return DHFactor.parseString(string);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
            return null;
        }
    }

    public static ElementList parseString(String string) {
        ElementList elementList = new ElementList();
        try {
            System.out.println(string);
            Pattern pattern = Pattern.compile("([RT][xyz]\\([^)]+\\))");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                elementList.add(new Element(matcher.group(1)));
            }
            System.out.println(elementList);
            elementList.simplify();
            System.out.println(elementList);
            elementList.factorize(6, 0);
            System.out.println(elementList);
            return elementList;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1) {
            ElementList elementList = DHFactor.parseString(stringArray[0]);
            System.err.println(elementList);
        } else {
            ElementList elementList = DHFactor.parseStdin();
            System.err.println(elementList);
        }
    }
}

