/*
 * Decompiled with CFR 0.152.
 */
class Element {
    static final int TX = 0;
    static final int TY = 1;
    static final int TZ = 2;
    static final int RX = 3;
    static final int RY = 4;
    static final int RZ = 5;
    static final int DH_STANDARD = 6;
    static final int DH_MODIFIED = 7;
    int type;
    String var;
    String symconst;
    int constant;
    int theta;
    int alpha;
    String A;
    String D;
    int prismatic;
    int offset;
    static int[] rules = new int[20];
    static final String[] typeName = new String[]{"Tx", "Ty", "Tz", "Rx", "Ry", "Rz", "DH", "DHm"};
    static final int[][] dhStandard = new int[][]{{5, 1}, {0, 0}, {2, 1}, {3, 0}};
    static final int[][] dhModified = new int[][]{{3, 0}, {0, 0}, {5, 1}, {2, 1}};

    public static void showRuleUsage() {
        for (int i = 0; i < 20; ++i) {
            if (rules[i] <= 0) continue;
            System.out.println("Rule " + i + ": " + rules[i]);
        }
    }

    public boolean istrans() {
        return this.type == 0 || this.type == 1 || this.type == 2;
    }

    public boolean isrot() {
        return this.type == 3 || this.type == 4 || this.type == 5;
    }

    public boolean isjoint() {
        return this.var != null;
    }

    public int axis() {
        switch (this.type) {
            case 0: 
            case 3: {
                return 0;
            }
            case 1: 
            case 4: {
                return 1;
            }
            case 2: 
            case 5: {
                return 2;
            }
        }
        throw new IllegalArgumentException("bad transform type");
    }

    private String symAdd(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string != null && string2 == null) {
            return new String(string);
        }
        if (string == null && string2 != null) {
            return new String(string2);
        }
        if (string2.charAt(0) == '-') {
            return string + string2;
        }
        return string + "+" + string2;
    }

    public void add(Element element) {
        if (this.type != 6 && this.type != 7) {
            throw new IllegalArgumentException("wrong element type " + this);
        }
        System.out.println("  adding: " + this + " += " + element);
        switch (element.type) {
            case 5: {
                if (element.isjoint()) {
                    this.prismatic = 0;
                    this.var = element.var;
                    this.offset = element.constant;
                    this.theta = 0;
                    break;
                }
                this.theta = element.constant;
                break;
            }
            case 0: {
                this.A = element.symconst;
                break;
            }
            case 2: {
                if (element.isjoint()) {
                    this.prismatic = 1;
                    this.var = element.var;
                    this.D = null;
                    break;
                }
                this.D = element.symconst;
                break;
            }
            case 3: {
                this.alpha = element.constant;
                break;
            }
            default: {
                throw new IllegalArgumentException("cant factorize " + element);
            }
        }
    }

    public boolean factorMatch(int n, int n2, int n3) {
        boolean bl;
        int[][] nArray;
        switch (n) {
            case 6: {
                nArray = dhStandard;
                break;
            }
            case 7: {
                nArray = dhModified;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad DH type");
            }
        }
        boolean bl2 = bl = this.type == nArray[n2][0] && (nArray[n2][1] != 0 || !this.isjoint());
        if (n3 > 0) {
            System.out.println(" matching " + this + " (i=" + n2 + ") " + " to " + typeName[nArray[n2][0]] + "<" + nArray[n2][1] + ">" + " -> " + bl);
        }
        return bl;
    }

    Element merge(Element element) {
        if (element.type != this.type || element.isjoint() && this.isjoint()) {
            return this;
        }
        Element element2 = new Element(this);
        element2.var = this.symAdd(this.var, element.var);
        element2.symconst = this.symAdd(this.symconst, element.symconst);
        element2.constant = this.constant + element.constant;
        if (!element2.isjoint() && element2.symconst == null && element2.constant == 0) {
            System.out.println("Eliminate: " + this + " " + element);
            return null;
        }
        System.out.println("Merge: " + this + " " + element + " := " + element2);
        return element2;
    }

    boolean swap(Element element, int n) {
        if (this.isjoint() && element.isjoint()) {
            return false;
        }
        switch (n) {
            case 6: {
                int[] nArray = new int[]{2, 0, 3, 4, 0, 1};
                if (!(this.type == 2 && element.type == 0 || this.type == 0 && element.type == 3 && element.isjoint() || this.type == 1 && element.type == 4 && element.isjoint() || this.type == 2 && element.type == 5 && element.isjoint() || !this.isjoint() && this.type == 3 && element.type == 0 || !this.isjoint() && this.type == 4 && element.type == 1 || !this.isjoint() && !element.isjoint() && this.type == 2 && element.type == 5 || this.type == 1 && element.type == 2) && (this.type != 1 || element.type != 0)) break;
                System.out.println("Swap: " + this + " <-> " + element);
                return true;
            }
            case 7: {
                if (!(this.type == 3 && element.type == 0 || this.type == 4 && element.type == 1 || this.type == 5 && element.type == 2) && (this.type != 2 || element.type != 0)) break;
                System.out.println("Swap: " + this + " <-> " + element);
                return true;
            }
            default: {
                throw new IllegalArgumentException("bad DH type");
            }
        }
        return false;
    }

    Element[] substituteToZ() {
        Element[] elementArray = new Element[3];
        switch (this.type) {
            case 3: {
                elementArray[0] = new Element(4, 90);
                elementArray[1] = new Element(this, 5);
                elementArray[2] = new Element(4, -90);
                return elementArray;
            }
            case 4: {
                elementArray[0] = new Element(3, -90);
                elementArray[1] = new Element(this, 5);
                elementArray[2] = new Element(3, 90);
                return elementArray;
            }
            case 0: {
                elementArray[0] = new Element(4, 90);
                elementArray[1] = new Element(this, 2);
                elementArray[2] = new Element(4, -90);
                return elementArray;
            }
            case 1: {
                elementArray[0] = new Element(3, -90);
                elementArray[1] = new Element(this, 2);
                elementArray[2] = new Element(3, 90);
                return elementArray;
            }
        }
        return null;
    }

    Element[] substituteToZ(Element element) {
        Element[] elementArray = new Element[3];
        switch (this.type) {
            case 4: {
                elementArray[0] = new Element(5, 90);
                elementArray[1] = new Element(this, 3);
                elementArray[2] = new Element(5, -90);
                rules[8] = rules[8] + 1;
                return elementArray;
            }
            case 1: {
                if (element.type == 5) {
                    elementArray[0] = new Element(5, 90);
                    elementArray[1] = new Element(this, 0);
                    elementArray[2] = new Element(5, -90);
                    rules[6] = rules[6] + 1;
                    return elementArray;
                }
                elementArray[0] = new Element(3, -90);
                elementArray[1] = new Element(this, 2);
                elementArray[2] = new Element(3, 90);
                rules[7] = rules[7] + 1;
                return elementArray;
            }
        }
        return null;
    }

    Element[] substituteY(Element element, Element element2) {
        Element[] elementArray = new Element[2];
        if (element.isjoint() || this.isjoint()) {
            return null;
        }
        if (element.type == 3 && this.type == 1) {
            elementArray[0] = new Element(this, 2, element.constant);
            elementArray[1] = new Element(element);
            rules[0] = rules[0] + 1;
            return elementArray;
        }
        if (element.type == 3 && this.type == 2) {
            elementArray[0] = new Element(this, 1, -element.constant);
            elementArray[1] = new Element(element);
            rules[2] = rules[2] + 1;
            return elementArray;
        }
        if (element.type == 4 && this.type == 0) {
            elementArray[0] = new Element(this, 2, -element.constant);
            elementArray[1] = new Element(element);
            rules[1] = rules[1] + 1;
            return elementArray;
        }
        if (element.type == 4 && this.type == 2) {
            elementArray[0] = new Element(this, 0, element.constant);
            elementArray[1] = new Element(element);
            rules[11] = rules[11] + 1;
            return elementArray;
        }
        if (element.type == 1 && this.type == 3) {
            elementArray[0] = new Element(this);
            elementArray[1] = new Element(element, 2, -this.constant);
            rules[5] = rules[5] + 1;
            return null;
        }
        if (element.type == 4 && this.type == 3) {
            elementArray[0] = new Element(this);
            elementArray[1] = new Element(element, 5, -1);
            rules[3] = rules[3] + 1;
            return elementArray;
        }
        if (element.type == 3 && this.type == 4) {
            elementArray[0] = new Element(this, 5);
            elementArray[1] = new Element(element);
            rules[4] = rules[4] + 1;
            return elementArray;
        }
        if (element.type == 5 && this.type == 3) {
            elementArray[0] = new Element(this);
            elementArray[1] = new Element(element, 4);
            return null;
        }
        return null;
    }

    public Element(int n, int n2) {
        this.type = n;
        this.var = null;
        this.symconst = null;
        this.constant = n2;
    }

    public Element(int n) {
        this.type = n;
    }

    public Element(Element element) {
        this.type = element.type;
        if (element.var != null) {
            this.var = new String(element.var);
        }
        if (element.symconst != null) {
            this.symconst = new String(element.symconst);
        }
        this.constant = element.constant;
    }

    public Element(Element element, int n, int n2) {
        this.type = n;
        if (element.var != null) {
            this.var = new String(element.var);
        }
        this.constant = element.constant;
        if (element.symconst != null) {
            this.symconst = new String(element.symconst);
        }
        if (n2 < 0) {
            this.negate();
        }
    }

    public Element(Element element, int n) {
        this(element, n, 1);
    }

    public void negate() {
        this.constant = -this.constant;
        if (this.symconst != null) {
            StringBuffer stringBuffer = new StringBuffer(this.symconst);
            if (stringBuffer.charAt(0) != '+' && stringBuffer.charAt(0) != '-') {
                stringBuffer.insert(0, '+');
            }
            block4: for (int i = 0; i < stringBuffer.length(); ++i) {
                switch (stringBuffer.charAt(i)) {
                    case '+': {
                        stringBuffer.setCharAt(i, '-');
                        continue block4;
                    }
                    case '-': {
                        stringBuffer.setCharAt(i, '+');
                        continue block4;
                    }
                }
            }
            if (stringBuffer.charAt(0) == '+') {
                stringBuffer.delete(0, 1);
            }
            this.symconst = new String(stringBuffer);
        }
    }

    public Element(String string) throws IllegalArgumentException {
        int n;
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2);
        if (!string3.endsWith(")") || !string3.startsWith("(")) {
            throw new IllegalArgumentException("brackets");
        }
        for (n = 0; n < 6 && !string2.equalsIgnoreCase(typeName[n]); ++n) {
        }
        if (n >= 6) {
            throw new IllegalArgumentException("bad transform name" + string2);
        }
        this.type = n;
        string3 = string3.substring(1, string3.length() - 1);
        String string4 = "";
        if (string3.charAt(0) == '-') {
            string4 = "-";
            string3 = string3.substring(1);
        }
        switch (string3.charAt(0)) {
            case 'q': {
                this.var = string4 + string3;
                break;
            }
            case 'L': {
                this.symconst = string4 + string3;
                break;
            }
            default: {
                try {
                    this.constant = Integer.parseInt(string3);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                    throw new IllegalArgumentException("bad argument in term " + string);
                }
            }
        }
    }

    public String argString() {
        String string = "";
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.var != null) {
                    string = this.var;
                }
                if (this.symconst != null) {
                    if (this.var != null && this.symconst.charAt(0) != '-') {
                        string = string + "+";
                    }
                    string = string + this.symconst;
                }
                if (this.constant == 0) break;
                string = string + (this.constant < 0 ? "" : "+") + this.constant;
                break;
            }
            case 6: 
            case 7: {
                if (this.prismatic == 0) {
                    string = string + this.var;
                    if (this.offset > 0) {
                        string = string + "+" + this.offset;
                    } else if (this.offset < 0) {
                        string = string + this.offset;
                    }
                } else {
                    string = string + this.theta;
                }
                string = string + ", ";
                string = this.prismatic > 0 ? string + this.var : string + (this.D == null ? "0" : this.D);
                string = string + ", ";
                string = string + (this.A == null ? "0" : this.A);
                string = string + ", ";
                string = string + this.alpha;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad Element type");
            }
        }
        return string;
    }

    public String toString() {
        String string = typeName[this.type] + "(";
        string = string + this.argString();
        string = string + ")";
        return string;
    }
}

