function [mag,f]=mag_cal(y,u,fs)
%
% This function computes the magnitude of the frequency response between u (input)
% and y (output) using the spectral analysis.
%
NFFT=1024;
wind=hanning(NFFT/2);
overlap=NFFT/4;
[Py,f]=psd(y,NFFT,fs,wind,overlap); %kaiser(NFFT,10.06126)
Pu=psd(u,NFFT,fs,wind,overlap);
Pyu=Py./Pu;
mag=10*log10(Pyu);
plot(f,mag);
