#include "PlotTool.h"
#include "LinTool.h"

#include "SDL.h"
#include "SDL_OpenGL.h"

#include <math.h>

#include <iostream>


int main( int argc, char* argv[] ) 
{ 
	int width = 480;
	int height = 480;
	int k,q;
	
	LT_matrix y(1000,2);
	LT_matrix x(1000,1);
	
	LT_matrix A(100,100);

	setup_SDL( width, height );
	
	setup_opengl( width, height ); 
	
	
	y.rand_fill(-10.0, 10.0);
	
	for (k=0; k<1000; k++)
	{
		y[k][0] = sin(double(k)/50) * (float(k)+1000.0)/2000.0;
		y[k][1] = sin(double(k)/150);
		
		x[k][0] = cos(double(k)/50);
	}
	
	for (k=0; k<100; k++)
	{
		for (q=0; q<100; q++)
		{
			A[k][q] = sin(double(k)/20.0) * sin(double(q)/20.0); 
		}
	}
	
	
	while( 1 )
	{ 
		/* Process incoming events. */ 
		process_events( ); 
		do_on_keystate();
		/* Draw the screen. */ 
		//plot2D(&y); 
		//plot2D(&x,&y); 
		surf(&A);
	}
	
	
	/* Never reached. */ 
	return 0; 
} 


