/**
* \file joystick_PC.cpp
* \author basile.graf@epfl.ch
* 
* This file contains functions related to the joystick under MS Windoze
*/


#include "joystick_PC.h"

#include "stdafx.h"

#include <windows.h>
#include <mmsystem.h> 



//Configurer SDK:
//http://msdn.microsoft.com/vstudio/express/visualc/usingpsdk/
//Joystick lib:
//http://msdn.microsoft.com/archive/default.asp?url=/archive/en-us/dnargame/html/msdn_dos2win2.asp
//Utiliser joystick windoze:
//http://tcharles.developpez.com/joystick/



JOYINFOEX ActualPos; // Etat actuel et dernier tat du joystick
DWORD dwBoutons; // Masque pour rcuprer l'tat des boutons
UINT uMax[2], uMin[2]; // Maximums et minimums de chacun des axes
UINT uPoolPeriod; // Temps entre deux introgations du joystick
JOYCAPS InfosCaps; // Infos sur les capacits du joystick
BOOL bStop; // Test d'arrt de la boucle (bouton 4)
POINT Curseur; // Curseur de la souris


int joystick_init()
{

//	AfficherJoysConnectes();
//	AfficherCaracs(0);

	//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	// initialisation du temps d'attente avec un minimum de 20 millisecondes
    uPoolPeriod = 20;

	if (joyGetDevCaps(JOYSTICKID1, &InfosCaps, sizeof(JOYCAPS)) != JOYERR_NOERROR) return 0;


    // Initialisation de la structure informationnelle avec sa taille
    ActualPos.dwSize = sizeof(JOYINFOEX);

    // Initialisation des autres membres que la taille de la structure  0
    // (Plus rapide que d'affecter 0  chaque lment. En effet, il est
    // obligatoire que tous les membres soient nuls sous peine d'chec)
    memset(&(ActualPos.dwFlags),0,sizeof(JOYINFOEX) - sizeof(DWORD));
    // Initialisation des variables d'tat actuel avant de lancer la boucle
    // de gestion du joystick
    ActualPos.dwFlags = JOY_RETURNALL;
    joyGetPosEx(JOYSTICKID1,&ActualPos);
    dwBoutons = ActualPos.dwButtons;

	return 1;
}



void joystick_getXYZR(float *X, float *Y, float *Z, float *R, bool doX, bool doY, bool doZ, bool doR)
{
	// on rinitialise ActualPos avant d'appeller l'API
    // pour savoir la position actuelle du joystick
    memset(&(ActualPos.dwFlags),0,sizeof(JOYINFOEX) - sizeof(DWORD));
    ActualPos.dwFlags = JOY_RETURNALL;
    joyGetPosEx(JOYSTICKID1,&ActualPos);

	if (doX) {*X = (float(ActualPos.dwXpos)/32768.0f) - 1.0f;}
	if (doY) {*Y = (float(ActualPos.dwYpos)/32768.0f) - 1.0f;}

	if (doZ) {*Z = (float(ActualPos.dwZpos)/32768.0f) - 1.0f;}
	if (doR) {*R = (float(ActualPos.dwRpos)/32768.0f) - 1.0f;}

	//std::cout<< "x: " << ActualPos.dwXpos << "y: " << ActualPos.dwYpos << "\n";
	//printf("x: %5d y: %5d\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b", ActualPos.dwXpos, ActualPos.dwYpos);

	// On patiente le avant de retester la position du joystick
    //Sleep(uPoolPeriod);
}

void joystick_close() //just in case MAC OSX needs such a function...
{
}