/**
* \file hydroMEX3.cpp
* \author basile.graf@epfl.ch
* 
* This is the main project file. It contains inteface to MATLAB and calls all the other routines. 
*/


//----------------Includes for graphics------------------------------------------
#include "oGL_graphics/graphics_relative.h"
#include "oGL_graphics/solid_objects.h"
//---------------------------------------------------------------------------------

//----------------Includes for MATLAB MEX------------------------------------------
#include "math.h"
#include "mex.h"   
//---------------------------------------------------------------------------------

#include "string.h"

//----------------Includes for hydropter-------------------------------------------
#include "hydro_source/hydro_includes.h"
//---------------------------------------------------------------------------------


//-------------Includes for SUNDIALS CVODE solver:---------------------------------
#include "CVODEincludes.h"  // ODE solver includes
//---------------------------------------------------------------------------------

//-------------Include for timing functions----------------------------------------
#include "timing/timing.h"
//---------------------------------------------------------------------------------

#include "f.h"


#define MAXFLAGLEN 100

#ifndef PI_DEF
#define pi 3.141592653589793
#define PI 3.141592653589793
#endif




/// Main function (mex function)
/** 
* This is the main function. It receives and returns pointers to the arguments to MATLAB. \n
* General initialisations and closing are done here. The main program loop is also in this function.
* \param nlhs Number of left hand side arguments in the MATLAB prompt
* \param *plhs[] Array of pointers to the left hand side arguments from MATLAB prompt
* \param nrhs Number of right hand side arguments in the MATLAB prompt
* \param *prhs[] Array of pointers to the right hand side arguments from MATLAB prompt
*/
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	///< IMPORTANT VARIABLES:
	parameters Par; ///< parameters Par;   parameters structure (from MATLAB)
	parameters *P = &Par; ///< parameters *P;  pointer to Par, will be passed to many functions
	joy_parameters jPar;  ///<  joy_parameters jPar;  joystick parameters structure (from MATLAB)
	joy_parameters *jP = &jPar;  ///< joy_parameters *jP;  pointer to jPar, will be passed to other functions
	datas dat;  ///<  datas dat;   model data structure containing all model (physics) informations
	datas *d = &dat; ///< pointer to dat, will be passed to many many functions
	ODE_data f_dats;  ///< ODE_data f_dats;  solver data structure, contains pointer to the other structures and some solver relative informations
	ODE_data *f_dat = &f_dats;  ///< ODE_data *f_dat;   pointer to f_dats, will be passed to solver relative functions


	int kk;

	double *state;
	char* flag;
	char def_flag[]  = "";
	char output_flag[]  = "output";
	long tLength;

	float Time;
	bool go=1;

	state = get_state(nlhs, plhs, nrhs, prhs);

	f_dat->d = d;
	f_dat->P = P;




	f_dat->state = state;


	initParameters(P);
	get_Parameters(nlhs, plhs, nrhs, prhs, P);

	get_time(nlhs, plhs, nrhs, prhs, f_dat);
	
	get_joystick_parameters(nlhs, plhs, nrhs, prhs, jP);
	pass_joy_parameters(jP);

	//flag = get_flag(nlhs, plhs, nrhs, prhs); //no more flag argument...


	data_init(d);
	data_update_state(d, state);
	data_update_param(d, P);



	solver_init(f_dat);

	kk = draw_graphics_init(d);//, gd);


	wave_init();

	Boat_create(d);


	tic();
	while (go)
	{
		Time = toc();
		solve_ODE(f_dat, Time);
		go = draw_graphics(d);
		if ((f_dat->time_param != 0.0) && (d->t > f_dat->time_param)) go=0;
	}

	free_wave_variables();

	kk = draw_graphics_kill();

	solver_free(f_dat);

	return_args(nlhs, plhs, nrhs, prhs, f_dat);


	delete_state(f_dat->state);
	Boat_delete();
	

	return;
}

