function [sys verif data_control] = Hydro_integ(t,state,flag,P)

param = P.param;


%C: in data_update_param:
x_foils = param(1); 
tanCal_yaw0 = param(2);
tanAngle_sail = param(5);
G_shift = param(6);
alpha_foils = param(7);
Wind_angle = param(9);
z_foils = param(10);


Datas
    

x = state(1);y = state(2); z = state(3); phi = state(4); theta = state(5) ; psi = state(6); 
dx = state(7);dy = state(8); dz = state(9); dphi = state(10); dtheta = state(11) ; dpsi = state(12);

x_cam = state(13);y_cam = state(14);z_cam = state(15);
dx_cam = state(16);dy_cam = state(17);dz_cam = state(18);

tanCal_yaw = tanCal_yaw0;

EE_flat

        verif(1)=EE_right_flat(1,1);
        verif(2)=EE_left_flat(1,1);
        verif(3)=EE_yaw_flat(1,1);

EE_left = EE_left_flat;
EE_right = EE_right_flat;
EE_yaw = EE_yaw_flat;


Fac_update = 1;
%Refine EEs
for k = 1:2
    Equ;
           verif(4)= Equ_left(1,1);
           verif(5)= Equ_right(1,1);
           verif(6)= Equ_yaw(1,1);
           verif(7)= dEqu_left(1,1); 
           verif(8)= dEqu_right(1,1);
           verif(9)= dEqu_yaw(1,1);

    EE_left = EE_left - Fac_update*Equ_left/dEqu_left;
    EE_right = EE_right - Fac_update*Equ_right/dEqu_right;
    EE_yaw = EE_yaw - Fac_update*Equ_yaw/dEqu_yaw;
   
end
 
% t = 0;

% Equ
% 
% Equ_left
% Equ_right


if (EE_left+epsilon < 0)
    EE_left = epsilon;
end
if (EE_right+epsilon < 0)
    EE_right = epsilon;
end
if (EE_left > E_foils-epsilon)
    EE_left = E_foils-epsilon;
end
if (EE_right > E_foils-epsilon)
    EE_right = E_foils-epsilon;
end
if (EE_yaw > E_yaw-epsilon)
    EE_yaw = E_yaw-epsilon;
end
if (EE_yaw+epsilon < 0)
    EE_yaw = epsilon;
end


Angles

            verif(10)= Tan_AoA_left;
			verif(11)= Tan_AoA_right;
			verif(12)= Tan_AoA_pitch;
			verif(13)= Tan_AoA_yaw;
			verif(14)= Tan_AoA_sail;

if (Tan_AoA_sail < 0)
    Tan_AoA_sail = 0;
end


Aero_coeff_control 

%copy_data_to_control;

Forces

%copy_data_to_control;

                verif(15)= Force_G_E1;
				verif(16)= Force_G_E2;
				verif(17)= Force_G_E3;
				verif(18)= Torque_G_E1;
				verif(19)= Torque_G_E2;
				verif(20)= Torque_G_E3;

Acceleration

                verif(21)= ddq(1);
				verif(22)= ddq(2);
				verif(23)= ddq(3);
				verif(24)= ddq(4);
				verif(25)= ddq(5);
				verif(26)= ddq(6);

% System definition

if (x+P.x_rel < P.x0)
    dd_cam = [0 0 0]';
    d_cam = [0 0 0]';
else
    if (t < P.time_stop)
    dd_cam = P.Gain*[ P.alpha_cam*(x_cam - (x + P.x_rel)) + P.beta_cam*(dx_cam - dx) ;
                      P.alpha_cam*(y_cam - (y + P.y_rel)) + P.beta_cam*(dy_cam - dy);
                      P.alpha_cam*(z_cam - (z + P.z_rel)) + P.beta_cam*(dz_cam - dz) ];
         
    else
    
     dd_cam = P.Gain*[P.beta_cam*dx_cam/3;
               	      P.beta_cam*dy_cam/3;
                      P.beta_cam*dz_cam/3 + 1];
    end
end
       
switch flag
	case ''	% System equation
	    
             %dx/dt
             sys(1:18,1) =   [dx;dy;dz;dphi;dtheta;dpsi;
                              ddq
                              dx_cam;
                              dy_cam;
                              dz_cam;
                              dd_cam];
            % t

        
	case 'output' 
		sys = [Tan_AoA_sail];
		
	otherwise
		error(['Unknown flag ''' flag '''.']);
	
end

copy_data_to_control;
	
