// Test programm for the LinTool simple linear algebra lybrary

#include <iostream>
#include <iomanip>
#include <stdlib.h>

#include <sys/times.h>
#include <sys/resource.h> 

#include "LinTool.h"

using namespace std;

#define n 50

double rmax=double(RAND_MAX);


double _get_time()
{
  struct rusage ruse;
  getrusage (RUSAGE_SELF, &ruse);
  return ((double)(ruse.ru_utime.tv_sec + ruse.ru_utime.tv_usec / 1e6));
} 




int main (int argc, char * const argv[])
{	
	int i;
	
	LT_matrix A(50,50);
	LT_matrix b(50,1);
	LT_matrix x(50,1);
	LT_matrix c(50,1);
	
	LT_matrix M1(4,4);
	LT_matrix M2(4,4);
	LT_matrix M3(4,4);
	
	LT_matrix T(3,4);
	
	cout<<"====================================="<<endl;
	
	M1.rand_fill(0.0, 1.0);
	cout<<"M1: "<<endl<<M1<<endl;
	M1.mult(2.0);
	cout<<"2*M1: "<<endl<<M1<<endl<<endl;
	
	M2.copy(&M1);
	cout<<"M2<-M1. M2:"<<endl<<M2<<endl;
	
	T.rand_fill(0.0,1.0);
	cout<<"T: \n"<<T<<endl;
	T.transp();
	cout<<"Tt: \n"<<T<<endl;
	
	cout<<"------"<<endl;
	
	A.rand_fill(-1.0, 1.0);
	b.rand_fill(-1.0, 1.0);

	
	double t=_get_time();
	printf("starting \n");
	for (i=0; i<1000; i++)
	{
		A.solve(&b, &x);
	}
	printf("done");
	t-=_get_time();
	printf("time: %f seconds \n",-t);
	
	cout<<"Numeric error:"<<endl;
	
	c.mult(&A,&x);
	c.sub(&c,&b);
	
	cout<< c <<endl;;
	
	cout<<"Systems per second: "<< 1000.0/-t<<endl;
	
	
	
	cout<<"====================================="<<endl;
		
	return 0;
}











