/**
* \file return_results_to_file.h
* \author basile.graf@epfl.ch
* 
* This file contains functions for writing simulation results to file
*/


#ifndef RETURN_RESULTS_TO_FILE_H_DEF
#define RETURN_RESULTS_TO_FILE_H_DEF

#include "math.h" 
#include "string.h"


/// Store state vector \f$ \vec{q}_i \f$ and time \f$ t_i \f$ at each integration step
/**
* If the programm has to return simulation results to file (see get_time()), 
* the state vector \f$ \vec{q}_i \f$ and the time \f$ t_i \f$ has to be stored at each integration step. 
* They are stored in dynamic C++ vectors of type vector.
* \param time \f$ t_i \f$
* \param state_at_t \f$ \vec{q}_i \f$ in the data format used by the SUNDIALS ODE solver CVODE
*/
void store_state_for_file(double time, N_Vector state_at_t);

/// Write simulation results to file
/**
* Write simulation results to file. The file is called "SimResults.sim" and is in binary format to save disc space.
* \return  0 : write OK.    1: write error (abort)
*/
int write_results_to_file();


#endif