/**
* \file graphics_relative.h
* \author basile.graf@epfl.ch
* 
* This file contains includes for graphical purposes and declarations for some graphic related functions 
*/



#ifndef GRAPHIC_RELATIVE_H_DEF
#define GRAPHIC_RELATIVE_H_DEF


#include "SDL.h"
#include "SDL_OpenGL.h"
#include "SDL_ttf/SDL_ttf.h"   



#include "../main.h"

#include "../hydro_source/Datas.h"
#include "Sea.h"

#include "solid_objects.h"

#include "../joystick_SDL/joystick_SDL.h"

#include "../hydro_source/hydro_includes.h"


GLuint* get_texture();

/// Callibrating phase?
/**
* Returns true if the program is in the joystick callibrating phase
*/
bool getCallibatingPhase();


/// Window resize callback
/**
* This function is called when the user modifies the window size
* \param height : height in pixels
* \param width : width in pixels
*/
void resize_window(int height, int width);


/// Setup for openGL
/**
* Does all the setup things neede by openGL
* \param height : height in pixels
* \param width : width in pixels
*/
void setup_opengl(int width, int height);


/// Setup for openGL
/**
* Does all the setup things neede by SDL
* \param height : height in pixels
* \param width : width in pixels
*/
void setup_SDL(int width, int height); 


/// Process events
/**
* Treats events like keyboard event,...
*/
void process_events( void );

/// On key-down event
/**
* Does what has to be done on keyboard key-down event (on time hit)
*/
void handle_key_down( SDL_keysym* keysym );


/// On key-down state
/**
* Does what has to be done on keyboard key-down state (long time pressed key)
*/
void do_on_keystate(datas *d);


/// On screen display font setup
/**
* On screen display is done using the SDL_ttf library. This function does the 
* setups for SDL_ttf and load the ttf font from file
*/
void setup_font();


/// On screen display font close
/**
* Closes the ttf font
*/
void close_font();


/// Draws the scene (openGL)
/**
* Draws the scene by appling all necessary geometrical (spacial) transformations and by calling
* the different element drawing functions (for the boat, the sea, the instruments...). This is not the highest
* function for drwaing the current scene, see draw_graphics().
*/
int DrawGLScene(datas* d);//, graphicDatas *gd);//int DrawGLScene(datas *d, seaDatas *sd, boatDatas *bd);
//GLvoid KillGLWindow(GLvoid);



/// Copy joystick parameters from MATLAB struct (obsolete (?))
/**
* Copy the joystick parameters (doX, doY ,doZ ,doR and dirX ,dirY ,diZ ,dirR) from the MATLAB struct *jP
* to the local joystick parameters variables.
* \param *jP : Structure comming from MATLAB or filled with default values defining joystick axes usage and direction.
*/
void pass_joy_parameters(joy_parameters *jP);
// c*********************************************************************

#endif