/**
* \file f.h
* \author basile.graf@epfl.ch
* 
* This file contains stuff related to evaluation
* of \f$ f \f$ in \f$ \frac{\partial\vec{q}}{\partial t}=f(\vec{q}, \vec{Q}, \vec{p}) \f$ 
* and stuff related to the ODE solver (initialisation, solving, closing)
*/




#ifndef F_H_DEF 
#define F_H_DEF 
 


static int f(realtype t, N_Vector y, N_Vector ydot, void *f_data);

void solver_init(ODE_data* f_dat);

void solve_ODE(ODE_data* f_dat, realtype tout);

void solver_free(ODE_data* f_dat);


 
#endif 
