/**
* \file return_mex_arguments.cpp
* \author basile.graf@epfl.ch
* 
* This file contains functions for returning parameters to MATLAB
*/


#include <vector>

#include "Datas.h"
#include "return_results_to_file.h"

#include "../CVODEincludes.h"  // ODE solver includes


#include <stdio.h>


using namespace std;


#ifndef PI_DEF
#define pi 3.141592653589793
#define PI 3.141592653589793
#endif

#define Ith(v,i)    NV_Ith_S(v,i)       /* Ith numbers components 1..NEQ */




 vector <double> sout00;
 vector <double> sout01;
 vector <double> sout02;
 vector <double> sout03;
 vector <double> sout04;
 vector <double> sout05;
 vector <double> sout06;
 vector <double> sout07;
 vector <double> sout08;
 vector <double> sout09;
 vector <double> sout10;
 vector <double> sout11;
 vector <double> timev;

void store_state_for_file(double time, N_Vector state_at_t)
{
	sout00.push_back(Ith(state_at_t,0));
	sout01.push_back(Ith(state_at_t,1));
	sout02.push_back(Ith(state_at_t,2));
	sout03.push_back(Ith(state_at_t,3));
	sout04.push_back(Ith(state_at_t,4));
	sout05.push_back(Ith(state_at_t,5));
	sout06.push_back(Ith(state_at_t,6));
	sout07.push_back(Ith(state_at_t,7));
	sout08.push_back(Ith(state_at_t,8));
	sout09.push_back(Ith(state_at_t,9));
	sout10.push_back(Ith(state_at_t,10));
	sout11.push_back(Ith(state_at_t,11));
	timev.push_back(time);
}


int write_results_to_file()
{
	long Nelem, k;
	int sizeElem;
	FILE *fp;
	
	
	Nelem = (long) sout00.size();
	sizeElem = sizeof(double);
	
	// Write to file:
	fp=fopen("SimResults.sim", "wb");
	
	if (fp!=NULL)
	{
		// Respect that order when reading!!!!!
		fwrite(&Nelem, sizeof(Nelem),1,fp);  // Store the number of vector elements that will be stored after
		printf("Nelem = %d \n", Nelem);
	
//  !!!!!!!!   VECTORS ARE STORED IN REVERSE ORDER     !!!!!!!!
		for (k=0; k<Nelem; k++) {fwrite(&sout00.back(), sizeElem, 1, fp); sout00.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout01.back(), sizeElem, 1, fp); sout01.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout02.back(), sizeElem, 1, fp); sout02.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout03.back(), sizeElem, 1, fp); sout03.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout04.back(), sizeElem, 1, fp); sout04.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout05.back(), sizeElem, 1, fp); sout05.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout06.back(), sizeElem, 1, fp); sout06.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout07.back(), sizeElem, 1, fp); sout07.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout08.back(), sizeElem, 1, fp); sout08.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout09.back(), sizeElem, 1, fp); sout09.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout10.back(), sizeElem, 1, fp); sout10.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&sout11.back(), sizeElem, 1, fp); sout11.pop_back();}
		for (k=0; k<Nelem; k++) {fwrite(&timev.back(), sizeElem, 1, fp); timev.pop_back();}
//  !!!!!!!!   VECTORS ARE STORED IN REVERSE ORDER     !!!!!!!!
		
	
		if (fclose(fp)) printf("Could not close the file!! \n");
		else printf("Writing to file 'SimResult.sim' done sucessfully. \n");
	}
	else
	{
		fprintf(stderr, "Could not open file stream (folder does not exist or is write protected), aborting... \n");
		return 1; // Write abort
	}
	
	return 0; //all OK
}