/**
* \file dataFillings.h
* \author basile.graf@epfl.ch
* 
* This file contains stuff for updating the datas datastructure pointed by *d
*/


#ifndef DATAS_FILL_H_DEF
#define DATAS_FILL_H_DEF

/// Initialize constants in the data strucure datas
/**
* Initialisation for constant values (like accleration \f$ g \f$, ...)
* \param *d : pointer to the datas data-structure
*/
void data_init(datas *d);


/// Update data structure datas from state-vector
/**
* Update data structure datas from state-vector (i.e. state or \f$ \vec{q} \f$)
* \param *d : pointer to the datas data-structure
* \param state: pointer to state vector (\f$ \vec{q} \f$, double[12])
*/
void data_update_state(datas* d, double *state);

/// Update data structure datas from values from structure *P
/**
* Update data structure datas from values from structure *P comming from MATLAB
* \param *d : pointer to the datas data-structure
* \param *P : pointer to parameters strucure comming from MATLAB
*/
void data_update_param(datas* d, parameters *P);


/// Updates angles from Target/Sliders instrument values
/**
* Updates sufaces-angles from Target/Sliders instrument values. 
* Angles should be controlled via these instrument variables so
* that both angles AND instrument appearence are modified!
* \param *d : pointer to the datas data-structure
*/
void angles_update(datas *d);

#endif