#include "math.h" 
#include "mex.h" 
#include "string.h" 

#include "Datas.h" 
#include "dataFillings.h" 
#include "analytics_geo.h" 

#ifndef PI_DEF 
#define pi 3.141592653589793 
#define PI 3.141592653589793 
#endif 

// File generated on 18-Apr-2006, Basile.Graf@epfl.ch 


 void EE_flat_compute(datas *d) { 
 
double trigoV[10]; 
 
trigoV[0] = sin(d->psi);
trigoV[1] = sin(d->phi);
trigoV[2] = sin(d->theta);
trigoV[3] = sin(d->alpha_right);
trigoV[4] = sin(d->alpha_left);
trigoV[5] = cos(d->psi);
trigoV[6] = cos(d->phi);
trigoV[7] = cos(d->theta);
trigoV[8] = cos(d->alpha_right);
trigoV[9] = cos(d->alpha_left);
 
 
d->EE_right_flat = -1.*(d->z+d->x_foils*trigoV[0]*trigoV[1]-1.*d->x_foils*trigoV[5]*trigoV[2]*trigoV[6]+trigoV[5]*trigoV[1]*d->y_foil_right+trigoV[0]*trigoV[2]*trigoV[6]*d->y_foil_right+trigoV[7]*trigoV[6]*d->z_foils)/(trigoV[5]*trigoV[1]*trigoV[8]+trigoV[0]*trigoV[2]*trigoV[6]*trigoV[8]-1.*trigoV[7]*trigoV[6]*trigoV[3]);
d->EE_left_flat = (d->z+d->x_foils*trigoV[0]*trigoV[1]-1.*d->x_foils*trigoV[5]*trigoV[2]*trigoV[6]+trigoV[5]*trigoV[1]*d->y_foil_left+trigoV[0]*trigoV[2]*trigoV[6]*d->y_foil_left+trigoV[7]*trigoV[6]*d->z_foils)/(trigoV[5]*trigoV[1]*trigoV[9]+trigoV[0]*trigoV[2]*trigoV[6]*trigoV[9]+trigoV[7]*trigoV[6]*trigoV[4]);
d->EE_yaw_flat = (d->z+d->x_yaw*trigoV[0]*trigoV[1]-1.*d->x_yaw*trigoV[5]*trigoV[2]*trigoV[6]+d->y_yaw*trigoV[5]*trigoV[1]+d->y_yaw*trigoV[0]*trigoV[2]*trigoV[6]+trigoV[7]*trigoV[6]*d->z_yaw)/trigoV[7]/trigoV[6];
return; 
} 
 
 
 void equ_compute(datas *d) { 
 
double trigoV[34]; 
 
trigoV[0] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle0)*d->x+cos(d->Wave_angle0)*d->x_foils*cos(d->psi)*cos(d->theta)-1.*cos(d->Wave_angle0)*sin(d->psi)*cos(d->theta)*d->y_foil_left+cos(d->Wave_angle0)*d->EE_left*sin(d->psi)*cos(d->theta)*cos(d->alpha_left)+cos(d->Wave_angle0)*d->z_foils*sin(d->theta)-1.*cos(d->Wave_angle0)*d->EE_left*sin(d->theta)*sin(d->alpha_left)+sin(d->Wave_angle0)*d->y+sin(d->Wave_angle0)*d->x_foils*sin(d->psi)*cos(d->phi)+sin(d->Wave_angle0)*d->x_foils*cos(d->psi)*sin(d->theta)*sin(d->phi)+sin(d->Wave_angle0)*cos(d->psi)*cos(d->phi)*d->y_foil_left-1.*sin(d->Wave_angle0)*cos(d->psi)*cos(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle0)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->y_foil_left+sin(d->Wave_angle0)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle0)*cos(d->theta)*sin(d->phi)*d->z_foils+sin(d->Wave_angle0)*cos(d->theta)*sin(d->phi)*d->EE_left*sin(d->alpha_left)+d->V_wave0*d->t)/d->Lambda0);
trigoV[1] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle1)*d->x+cos(d->Wave_angle1)*cos(d->psi)*cos(d->theta)*d->x_foils-1.*cos(d->Wave_angle1)*sin(d->psi)*cos(d->theta)*d->y_foil_left+cos(d->Wave_angle1)*sin(d->psi)*cos(d->theta)*d->EE_left*cos(d->alpha_left)+cos(d->Wave_angle1)*sin(d->theta)*d->z_foils-1.*cos(d->Wave_angle1)*sin(d->theta)*d->EE_left*sin(d->alpha_left)+sin(d->Wave_angle1)*d->y+sin(d->Wave_angle1)*d->x_foils*sin(d->psi)*cos(d->phi)+sin(d->Wave_angle1)*d->x_foils*cos(d->psi)*sin(d->theta)*sin(d->phi)+sin(d->Wave_angle1)*cos(d->psi)*cos(d->phi)*d->y_foil_left-1.*sin(d->Wave_angle1)*cos(d->psi)*cos(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle1)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->y_foil_left+sin(d->Wave_angle1)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle1)*cos(d->theta)*sin(d->phi)*d->z_foils+sin(d->Wave_angle1)*cos(d->theta)*sin(d->phi)*d->EE_left*sin(d->alpha_left)+d->V_wave1*d->t)/d->Lambda1);
trigoV[2] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle2)*d->x+cos(d->Wave_angle2)*cos(d->psi)*cos(d->theta)*d->x_foils-1.*cos(d->Wave_angle2)*sin(d->psi)*cos(d->theta)*d->y_foil_left+cos(d->Wave_angle2)*sin(d->psi)*cos(d->theta)*d->EE_left*cos(d->alpha_left)+cos(d->Wave_angle2)*sin(d->theta)*d->z_foils-1.*cos(d->Wave_angle2)*sin(d->theta)*d->EE_left*sin(d->alpha_left)+sin(d->Wave_angle2)*d->y+sin(d->Wave_angle2)*d->x_foils*sin(d->psi)*cos(d->phi)+sin(d->Wave_angle2)*d->x_foils*cos(d->psi)*sin(d->theta)*sin(d->phi)+sin(d->Wave_angle2)*cos(d->psi)*cos(d->phi)*d->y_foil_left-1.*sin(d->Wave_angle2)*cos(d->psi)*cos(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle2)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->y_foil_left+sin(d->Wave_angle2)*sin(d->psi)*sin(d->theta)*sin(d->phi)*d->EE_left*cos(d->alpha_left)-1.*sin(d->Wave_angle2)*cos(d->theta)*sin(d->phi)*d->z_foils+sin(d->Wave_angle2)*cos(d->theta)*sin(d->phi)*d->EE_left*sin(d->alpha_left)+d->V_wave2*d->t)/d->Lambda2);
trigoV[3] = sin(d->psi);
trigoV[4] = sin(d->phi);
trigoV[5] = sin(d->theta);
trigoV[6] = sin(d->alpha_left);
trigoV[7] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle0)*d->x+cos(d->Wave_angle0)*d->x_foils*cos(d->psi)*cos(d->theta)-1.*cos(d->Wave_angle0)*trigoV[3]*cos(d->theta)*d->y_foil_right-1.*cos(d->Wave_angle0)*trigoV[3]*cos(d->theta)*d->EE_right*cos(d->alpha_right)+cos(d->Wave_angle0)*d->z_foils*trigoV[5]-1.*cos(d->Wave_angle0)*trigoV[5]*d->EE_right*sin(d->alpha_right)+sin(d->Wave_angle0)*d->y+sin(d->Wave_angle0)*d->x_foils*trigoV[3]*cos(d->phi)+sin(d->Wave_angle0)*d->x_foils*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle0)*cos(d->psi)*cos(d->phi)*d->y_foil_right+sin(d->Wave_angle0)*cos(d->psi)*cos(d->phi)*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle0)*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*sin(d->Wave_angle0)*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle0)*cos(d->theta)*trigoV[4]*d->z_foils+sin(d->Wave_angle0)*cos(d->theta)*trigoV[4]*d->EE_right*sin(d->alpha_right)+d->V_wave0*d->t)/d->Lambda0);
trigoV[8] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle1)*d->x+cos(d->Wave_angle1)*cos(d->psi)*cos(d->theta)*d->x_foils-1.*cos(d->Wave_angle1)*trigoV[3]*cos(d->theta)*d->y_foil_right-1.*cos(d->Wave_angle1)*trigoV[3]*cos(d->theta)*d->EE_right*cos(d->alpha_right)+cos(d->Wave_angle1)*trigoV[5]*d->z_foils-1.*cos(d->Wave_angle1)*trigoV[5]*d->EE_right*sin(d->alpha_right)+sin(d->Wave_angle1)*d->y+sin(d->Wave_angle1)*d->x_foils*trigoV[3]*cos(d->phi)+sin(d->Wave_angle1)*d->x_foils*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle1)*cos(d->psi)*cos(d->phi)*d->y_foil_right+sin(d->Wave_angle1)*cos(d->psi)*cos(d->phi)*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle1)*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*sin(d->Wave_angle1)*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle1)*cos(d->theta)*trigoV[4]*d->z_foils+sin(d->Wave_angle1)*cos(d->theta)*trigoV[4]*d->EE_right*sin(d->alpha_right)+d->V_wave1*d->t)/d->Lambda1);
trigoV[9] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle2)*d->x+cos(d->Wave_angle2)*cos(d->psi)*cos(d->theta)*d->x_foils-1.*cos(d->Wave_angle2)*trigoV[3]*cos(d->theta)*d->y_foil_right-1.*cos(d->Wave_angle2)*trigoV[3]*cos(d->theta)*d->EE_right*cos(d->alpha_right)+cos(d->Wave_angle2)*trigoV[5]*d->z_foils-1.*cos(d->Wave_angle2)*trigoV[5]*d->EE_right*sin(d->alpha_right)+sin(d->Wave_angle2)*d->y+sin(d->Wave_angle2)*d->x_foils*trigoV[3]*cos(d->phi)+sin(d->Wave_angle2)*d->x_foils*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle2)*cos(d->psi)*cos(d->phi)*d->y_foil_right+sin(d->Wave_angle2)*cos(d->psi)*cos(d->phi)*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle2)*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*sin(d->Wave_angle2)*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*cos(d->alpha_right)-1.*sin(d->Wave_angle2)*cos(d->theta)*trigoV[4]*d->z_foils+sin(d->Wave_angle2)*cos(d->theta)*trigoV[4]*d->EE_right*sin(d->alpha_right)+d->V_wave2*d->t)/d->Lambda2);
trigoV[10] = sin(d->alpha_right);
trigoV[11] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle0)*d->x+cos(d->Wave_angle0)*cos(d->psi)*cos(d->theta)*d->x_yaw-1.*cos(d->Wave_angle0)*trigoV[3]*cos(d->theta)*d->y_yaw+cos(d->Wave_angle0)*trigoV[5]*d->z_yaw-1.*cos(d->Wave_angle0)*trigoV[5]*d->EE_yaw+sin(d->Wave_angle0)*d->y+sin(d->Wave_angle0)*d->x_yaw*trigoV[3]*cos(d->phi)+sin(d->Wave_angle0)*d->x_yaw*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle0)*d->y_yaw*cos(d->psi)*cos(d->phi)-1.*sin(d->Wave_angle0)*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*sin(d->Wave_angle0)*cos(d->theta)*trigoV[4]*d->z_yaw+sin(d->Wave_angle0)*cos(d->theta)*trigoV[4]*d->EE_yaw+d->V_wave0*d->t)/d->Lambda0);
trigoV[12] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle1)*d->x+cos(d->Wave_angle1)*cos(d->psi)*cos(d->theta)*d->x_yaw-1.*cos(d->Wave_angle1)*trigoV[3]*cos(d->theta)*d->y_yaw+cos(d->Wave_angle1)*trigoV[5]*d->z_yaw-1.*cos(d->Wave_angle1)*trigoV[5]*d->EE_yaw+sin(d->Wave_angle1)*d->y+sin(d->Wave_angle1)*d->x_yaw*trigoV[3]*cos(d->phi)+sin(d->Wave_angle1)*d->x_yaw*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle1)*d->y_yaw*cos(d->psi)*cos(d->phi)-1.*sin(d->Wave_angle1)*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*sin(d->Wave_angle1)*cos(d->theta)*trigoV[4]*d->z_yaw+sin(d->Wave_angle1)*cos(d->theta)*trigoV[4]*d->EE_yaw+d->V_wave1*d->t)/d->Lambda1);
trigoV[13] = sin(6.2831853071795864769252867665590*(cos(d->Wave_angle2)*d->x+cos(d->Wave_angle2)*cos(d->psi)*cos(d->theta)*d->x_yaw-1.*cos(d->Wave_angle2)*trigoV[3]*cos(d->theta)*d->y_yaw+cos(d->Wave_angle2)*trigoV[5]*d->z_yaw-1.*cos(d->Wave_angle2)*trigoV[5]*d->EE_yaw+sin(d->Wave_angle2)*d->y+sin(d->Wave_angle2)*d->x_yaw*trigoV[3]*cos(d->phi)+sin(d->Wave_angle2)*d->x_yaw*cos(d->psi)*trigoV[5]*trigoV[4]+sin(d->Wave_angle2)*d->y_yaw*cos(d->psi)*cos(d->phi)-1.*sin(d->Wave_angle2)*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*sin(d->Wave_angle2)*cos(d->theta)*trigoV[4]*d->z_yaw+sin(d->Wave_angle2)*cos(d->theta)*trigoV[4]*d->EE_yaw+d->V_wave2*d->t)/d->Lambda2);
trigoV[14] = sin(d->Wave_angle0);
trigoV[15] = sin(d->Wave_angle1);
trigoV[16] = sin(d->Wave_angle2);
trigoV[17] = cos(d->psi);
trigoV[18] = cos(d->phi);
trigoV[19] = cos(d->alpha_left);
trigoV[20] = cos(d->theta);
trigoV[21] = cos(d->alpha_right);
trigoV[22] = cos(6.2831853071795864769252867665590*(cos(d->Wave_angle0)*d->x+cos(d->Wave_angle0)*d->x_foils*trigoV[17]*trigoV[20]-1.*cos(d->Wave_angle0)*trigoV[3]*trigoV[20]*d->y_foil_left+cos(d->Wave_angle0)*d->EE_left*trigoV[3]*trigoV[20]*trigoV[19]+cos(d->Wave_angle0)*d->z_foils*trigoV[5]-1.*cos(d->Wave_angle0)*d->EE_left*trigoV[5]*trigoV[6]+trigoV[14]*d->y+trigoV[14]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[14]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[14]*trigoV[17]*trigoV[18]*d->y_foil_left-1.*trigoV[14]*trigoV[17]*trigoV[18]*d->EE_left*trigoV[19]-1.*trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_left+trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_left*trigoV[19]-1.*trigoV[14]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[14]*trigoV[20]*trigoV[4]*d->EE_left*trigoV[6]+d->V_wave0*d->t)/d->Lambda0);
trigoV[23] = cos(d->Wave_angle0);
trigoV[24] = cos(6.2831853071795864769252867665590*(cos(d->Wave_angle1)*d->x+cos(d->Wave_angle1)*trigoV[17]*trigoV[20]*d->x_foils-1.*cos(d->Wave_angle1)*trigoV[3]*trigoV[20]*d->y_foil_left+cos(d->Wave_angle1)*trigoV[3]*trigoV[20]*d->EE_left*trigoV[19]+cos(d->Wave_angle1)*trigoV[5]*d->z_foils-1.*cos(d->Wave_angle1)*trigoV[5]*d->EE_left*trigoV[6]+trigoV[15]*d->y+trigoV[15]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[15]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[15]*trigoV[17]*trigoV[18]*d->y_foil_left-1.*trigoV[15]*trigoV[17]*trigoV[18]*d->EE_left*trigoV[19]-1.*trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_left+trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_left*trigoV[19]-1.*trigoV[15]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[15]*trigoV[20]*trigoV[4]*d->EE_left*trigoV[6]+d->V_wave1*d->t)/d->Lambda1);
trigoV[25] = cos(d->Wave_angle1);
trigoV[26] = cos(6.2831853071795864769252867665590*(cos(d->Wave_angle2)*d->x+cos(d->Wave_angle2)*trigoV[17]*trigoV[20]*d->x_foils-1.*cos(d->Wave_angle2)*trigoV[3]*trigoV[20]*d->y_foil_left+cos(d->Wave_angle2)*trigoV[3]*trigoV[20]*d->EE_left*trigoV[19]+cos(d->Wave_angle2)*trigoV[5]*d->z_foils-1.*cos(d->Wave_angle2)*trigoV[5]*d->EE_left*trigoV[6]+trigoV[16]*d->y+trigoV[16]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[16]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[16]*trigoV[17]*trigoV[18]*d->y_foil_left-1.*trigoV[16]*trigoV[17]*trigoV[18]*d->EE_left*trigoV[19]-1.*trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_left+trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_left*trigoV[19]-1.*trigoV[16]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[16]*trigoV[20]*trigoV[4]*d->EE_left*trigoV[6]+d->V_wave2*d->t)/d->Lambda2);
trigoV[27] = cos(d->Wave_angle2);
trigoV[28] = cos(6.2831853071795864769252867665590*(trigoV[23]*d->x+trigoV[23]*d->x_foils*trigoV[17]*trigoV[20]-1.*trigoV[23]*trigoV[3]*trigoV[20]*d->y_foil_right-1.*trigoV[23]*trigoV[3]*trigoV[20]*d->EE_right*trigoV[21]+trigoV[23]*d->z_foils*trigoV[5]-1.*trigoV[23]*trigoV[5]*d->EE_right*trigoV[10]+trigoV[14]*d->y+trigoV[14]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[14]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[14]*trigoV[17]*trigoV[18]*d->y_foil_right+trigoV[14]*trigoV[17]*trigoV[18]*d->EE_right*trigoV[21]-1.*trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*trigoV[21]-1.*trigoV[14]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[14]*trigoV[20]*trigoV[4]*d->EE_right*trigoV[10]+d->V_wave0*d->t)/d->Lambda0);
trigoV[29] = cos(6.2831853071795864769252867665590*(trigoV[25]*d->x+trigoV[25]*trigoV[17]*trigoV[20]*d->x_foils-1.*trigoV[25]*trigoV[3]*trigoV[20]*d->y_foil_right-1.*trigoV[25]*trigoV[3]*trigoV[20]*d->EE_right*trigoV[21]+trigoV[25]*trigoV[5]*d->z_foils-1.*trigoV[25]*trigoV[5]*d->EE_right*trigoV[10]+trigoV[15]*d->y+trigoV[15]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[15]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[15]*trigoV[17]*trigoV[18]*d->y_foil_right+trigoV[15]*trigoV[17]*trigoV[18]*d->EE_right*trigoV[21]-1.*trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*trigoV[21]-1.*trigoV[15]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[15]*trigoV[20]*trigoV[4]*d->EE_right*trigoV[10]+d->V_wave1*d->t)/d->Lambda1);
trigoV[30] = cos(6.2831853071795864769252867665590*(trigoV[27]*d->x+trigoV[27]*trigoV[17]*trigoV[20]*d->x_foils-1.*trigoV[27]*trigoV[3]*trigoV[20]*d->y_foil_right-1.*trigoV[27]*trigoV[3]*trigoV[20]*d->EE_right*trigoV[21]+trigoV[27]*trigoV[5]*d->z_foils-1.*trigoV[27]*trigoV[5]*d->EE_right*trigoV[10]+trigoV[16]*d->y+trigoV[16]*d->x_foils*trigoV[3]*trigoV[18]+trigoV[16]*d->x_foils*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[16]*trigoV[17]*trigoV[18]*d->y_foil_right+trigoV[16]*trigoV[17]*trigoV[18]*d->EE_right*trigoV[21]-1.*trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*d->y_foil_right-1.*trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*d->EE_right*trigoV[21]-1.*trigoV[16]*trigoV[20]*trigoV[4]*d->z_foils+trigoV[16]*trigoV[20]*trigoV[4]*d->EE_right*trigoV[10]+d->V_wave2*d->t)/d->Lambda2);
trigoV[31] = cos(6.2831853071795864769252867665590*(trigoV[23]*d->x+trigoV[23]*trigoV[17]*trigoV[20]*d->x_yaw-1.*trigoV[23]*trigoV[3]*trigoV[20]*d->y_yaw+trigoV[23]*trigoV[5]*d->z_yaw-1.*trigoV[23]*trigoV[5]*d->EE_yaw+trigoV[14]*d->y+trigoV[14]*d->x_yaw*trigoV[3]*trigoV[18]+trigoV[14]*d->x_yaw*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[14]*d->y_yaw*trigoV[17]*trigoV[18]-1.*trigoV[14]*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*trigoV[14]*trigoV[20]*trigoV[4]*d->z_yaw+trigoV[14]*trigoV[20]*trigoV[4]*d->EE_yaw+d->V_wave0*d->t)/d->Lambda0);
trigoV[32] = cos(6.2831853071795864769252867665590*(trigoV[25]*d->x+trigoV[25]*trigoV[17]*trigoV[20]*d->x_yaw-1.*trigoV[25]*trigoV[3]*trigoV[20]*d->y_yaw+trigoV[25]*trigoV[5]*d->z_yaw-1.*trigoV[25]*trigoV[5]*d->EE_yaw+trigoV[15]*d->y+trigoV[15]*d->x_yaw*trigoV[3]*trigoV[18]+trigoV[15]*d->x_yaw*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[15]*d->y_yaw*trigoV[17]*trigoV[18]-1.*trigoV[15]*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*trigoV[15]*trigoV[20]*trigoV[4]*d->z_yaw+trigoV[15]*trigoV[20]*trigoV[4]*d->EE_yaw+d->V_wave1*d->t)/d->Lambda1);
trigoV[33] = cos(6.2831853071795864769252867665590*(trigoV[27]*d->x+trigoV[27]*trigoV[17]*trigoV[20]*d->x_yaw-1.*trigoV[27]*trigoV[3]*trigoV[20]*d->y_yaw+trigoV[27]*trigoV[5]*d->z_yaw-1.*trigoV[27]*trigoV[5]*d->EE_yaw+trigoV[16]*d->y+trigoV[16]*d->x_yaw*trigoV[3]*trigoV[18]+trigoV[16]*d->x_yaw*trigoV[17]*trigoV[5]*trigoV[4]+trigoV[16]*d->y_yaw*trigoV[17]*trigoV[18]-1.*trigoV[16]*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[4]-1.*trigoV[16]*trigoV[20]*trigoV[4]*d->z_yaw+trigoV[16]*trigoV[20]*trigoV[4]*d->EE_yaw+d->V_wave2*d->t)/d->Lambda2);
 
 
d->Equ_left = d->Wave_amp0*trigoV[0]+d->Wave_amp1*trigoV[1]+d->Wave_amp2*trigoV[2]-1.*d->z-1.*d->x_foils*trigoV[3]*trigoV[4]+d->x_foils*trigoV[17]*trigoV[5]*trigoV[18]-1.*trigoV[17]*trigoV[4]*d->y_foil_left+trigoV[17]*trigoV[4]*trigoV[19]*d->EE_left-1.*trigoV[3]*trigoV[5]*trigoV[18]*d->y_foil_left+trigoV[3]*trigoV[5]*trigoV[18]*trigoV[19]*d->EE_left-1.*trigoV[20]*trigoV[18]*d->z_foils+trigoV[20]*trigoV[18]*trigoV[6]*d->EE_left;
d->Equ_right = d->Wave_amp0*trigoV[7]+d->Wave_amp1*trigoV[8]+d->Wave_amp2*trigoV[9]-1.*d->z-1.*d->x_foils*trigoV[3]*trigoV[4]+d->x_foils*trigoV[17]*trigoV[5]*trigoV[18]-1.*trigoV[17]*trigoV[4]*d->y_foil_right-1.*trigoV[17]*trigoV[4]*d->EE_right*trigoV[21]-1.*trigoV[3]*trigoV[5]*trigoV[18]*d->y_foil_right-1.*trigoV[3]*trigoV[5]*trigoV[18]*d->EE_right*trigoV[21]-1.*trigoV[20]*trigoV[18]*d->z_foils+trigoV[20]*trigoV[18]*d->EE_right*trigoV[10];
d->Equ_yaw = d->Wave_amp0*trigoV[11]+d->Wave_amp1*trigoV[12]+d->Wave_amp2*trigoV[13]-1.*d->z-1.*d->x_yaw*trigoV[3]*trigoV[4]+d->x_yaw*trigoV[17]*trigoV[5]*trigoV[18]-1.*d->y_yaw*trigoV[17]*trigoV[4]-1.*d->y_yaw*trigoV[3]*trigoV[5]*trigoV[18]-1.*trigoV[20]*trigoV[18]*d->z_yaw+trigoV[20]*trigoV[18]*d->EE_yaw;
d->dEqu_left = -1.*(6.2831853071795864769252867665590*d->Wave_amp0*trigoV[22]*d->Lambda1*d->Lambda2*trigoV[23]*trigoV[5]*trigoV[6]+6.2831853071795864769252867665590*d->Wave_amp0*trigoV[22]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[17]*trigoV[18]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[22]*d->Lambda1*d->Lambda2*trigoV[23]*trigoV[3]*trigoV[20]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[22]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[22]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[20]*trigoV[4]*trigoV[6]+6.2831853071795864769252867665590*d->Wave_amp1*trigoV[24]*d->Lambda0*d->Lambda2*trigoV[25]*trigoV[5]*trigoV[6]+6.2831853071795864769252867665590*d->Wave_amp1*trigoV[24]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[17]*trigoV[18]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[24]*d->Lambda0*d->Lambda2*trigoV[25]*trigoV[3]*trigoV[20]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[24]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[24]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[20]*trigoV[4]*trigoV[6]+6.2831853071795864769252867665590*d->Wave_amp2*trigoV[26]*d->Lambda0*d->Lambda1*trigoV[27]*trigoV[5]*trigoV[6]+6.2831853071795864769252867665590*d->Wave_amp2*trigoV[26]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[17]*trigoV[18]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[26]*d->Lambda0*d->Lambda1*trigoV[27]*trigoV[3]*trigoV[20]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[26]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[19]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[26]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[20]*trigoV[4]*trigoV[6]-1.*trigoV[17]*trigoV[4]*trigoV[19]*d->Lambda0*d->Lambda1*d->Lambda2-1.*trigoV[3]*trigoV[5]*trigoV[18]*trigoV[19]*d->Lambda0*d->Lambda1*d->Lambda2-1.*trigoV[20]*trigoV[18]*trigoV[6]*d->Lambda0*d->Lambda1*d->Lambda2)/d->Lambda0/d->Lambda1/d->Lambda2;
d->dEqu_right = (-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[28]*d->Lambda1*d->Lambda2*trigoV[23]*trigoV[5]*trigoV[10]+6.2831853071795864769252867665590*d->Wave_amp0*trigoV[28]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[17]*trigoV[18]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[28]*d->Lambda1*d->Lambda2*trigoV[23]*trigoV[3]*trigoV[20]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[28]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[21]+6.2831853071795864769252867665590*d->Wave_amp0*trigoV[28]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[20]*trigoV[4]*trigoV[10]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[29]*d->Lambda0*d->Lambda2*trigoV[25]*trigoV[5]*trigoV[10]+6.2831853071795864769252867665590*d->Wave_amp1*trigoV[29]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[17]*trigoV[18]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[29]*d->Lambda0*d->Lambda2*trigoV[25]*trigoV[3]*trigoV[20]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[29]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[21]+6.2831853071795864769252867665590*d->Wave_amp1*trigoV[29]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[20]*trigoV[4]*trigoV[10]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[30]*d->Lambda0*d->Lambda1*trigoV[27]*trigoV[5]*trigoV[10]+6.2831853071795864769252867665590*d->Wave_amp2*trigoV[30]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[17]*trigoV[18]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[30]*d->Lambda0*d->Lambda1*trigoV[27]*trigoV[3]*trigoV[20]*trigoV[21]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[30]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[3]*trigoV[5]*trigoV[4]*trigoV[21]+6.2831853071795864769252867665590*d->Wave_amp2*trigoV[30]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[20]*trigoV[4]*trigoV[10]-1.*trigoV[17]*trigoV[4]*trigoV[21]*d->Lambda0*d->Lambda1*d->Lambda2-1.*trigoV[3]*trigoV[5]*trigoV[18]*trigoV[21]*d->Lambda0*d->Lambda1*d->Lambda2+trigoV[20]*trigoV[18]*trigoV[10]*d->Lambda0*d->Lambda1*d->Lambda2)/d->Lambda0/d->Lambda1/d->Lambda2;
d->dEqu_yaw = -1.*(6.2831853071795864769252867665590*d->Wave_amp0*trigoV[31]*d->Lambda1*d->Lambda2*trigoV[23]*trigoV[5]-6.2831853071795864769252867665590*d->Wave_amp0*trigoV[31]*d->Lambda1*d->Lambda2*trigoV[14]*trigoV[20]*trigoV[4]+6.2831853071795864769252867665590*d->Wave_amp1*trigoV[32]*d->Lambda0*d->Lambda2*trigoV[25]*trigoV[5]-6.2831853071795864769252867665590*d->Wave_amp1*trigoV[32]*d->Lambda0*d->Lambda2*trigoV[15]*trigoV[20]*trigoV[4]+6.2831853071795864769252867665590*d->Wave_amp2*trigoV[33]*d->Lambda0*d->Lambda1*trigoV[27]*trigoV[5]-6.2831853071795864769252867665590*d->Wave_amp2*trigoV[33]*d->Lambda0*d->Lambda1*trigoV[16]*trigoV[20]*trigoV[4]-1.*trigoV[20]*trigoV[18]*d->Lambda0*d->Lambda1*d->Lambda2)/d->Lambda0/d->Lambda1/d->Lambda2;
return; 
} 
 
 
 void angles_compute(datas *d) { 
 
double tempV[10]; 
double trigoV[10]; 
 
trigoV[0] = sin(d->alpha_left);
trigoV[1] = sin(d->psi);
trigoV[2] = sin(d->theta);
trigoV[3] = sin(d->phi);
trigoV[4] = sin(d->alpha_right);
trigoV[5] = cos(d->theta);
trigoV[6] = cos(d->psi);
trigoV[7] = cos(d->phi);
trigoV[8] = cos(d->alpha_left);
trigoV[9] = cos(d->alpha_right);
 
tempV[0] = d->dphi*trigoV[6]*trigoV[5]+d->dtheta*trigoV[1];
tempV[1] = d->dphi*trigoV[2]+d->dpsi;
tempV[2] = -1.*d->dphi*trigoV[1]*trigoV[5]+d->dtheta*trigoV[6];
tempV[3] = (trigoV[1]*trigoV[3]-1.*trigoV[6]*trigoV[2]*trigoV[7])*d->dz;
tempV[4] = (trigoV[1]*trigoV[7]+trigoV[6]*trigoV[2]*trigoV[3])*d->dy;
tempV[5] = (trigoV[6]*trigoV[3]+trigoV[1]*trigoV[2]*trigoV[7])*d->dz;
tempV[6] = (trigoV[6]*trigoV[7]-1.*trigoV[1]*trigoV[2]*trigoV[3])*d->dy;
tempV[7] = .33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right;
tempV[8] = d->Chord_max-1.*d->Chord_min;
tempV[9] = -.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left;
 
d->Tan_AoA_left = (trigoV[0]*(-1.*trigoV[1]*trigoV[5]*d->dx+tempV[6]+tempV[5])-1.*trigoV[8]*(trigoV[2]*d->dx-1.*trigoV[5]*trigoV[3]*d->dy+trigoV[5]*trigoV[7]*d->dz)+trigoV[0]*(tempV[1]*(d->x_foils+.33333333333333333333333333333333*d->EE_left*tempV[8]/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*tempV[0]*(d->z_foils+trigoV[0]*tempV[9]))-1.*trigoV[8]*(tempV[0]*(d->y_foil_left+trigoV[8]*tempV[9])-1.*tempV[2]*(d->x_foils+.33333333333333333333333333333333*d->EE_left*tempV[8]/d->E_foils-.33333333333333333333333333333333*d->Chord_max)))/(trigoV[6]*trigoV[5]*d->dx+tempV[4]+tempV[3]+tempV[2]*(d->z_foils+trigoV[0]*tempV[9])-1.*tempV[1]*(d->y_foil_left+trigoV[8]*tempV[9]))+d->tanCal_left;
d->Tan_AoA_right = (-1.*trigoV[4]*(-1.*trigoV[1]*trigoV[5]*d->dx+tempV[6]+tempV[5])-1.*trigoV[9]*(trigoV[2]*d->dx-1.*trigoV[5]*trigoV[3]*d->dy+trigoV[5]*trigoV[7]*d->dz)-1.*trigoV[4]*(tempV[1]*(d->x_foils+.33333333333333333333333333333333*d->EE_right*tempV[8]/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*tempV[0]*(d->z_foils-1.*trigoV[4]*tempV[7]))-1.*trigoV[9]*(tempV[0]*(d->y_foil_right+trigoV[9]*tempV[7])-1.*tempV[2]*(d->x_foils+.33333333333333333333333333333333*d->EE_right*tempV[8]/d->E_foils-.33333333333333333333333333333333*d->Chord_max)))/(trigoV[6]*trigoV[5]*d->dx+tempV[4]+tempV[3]+tempV[2]*(d->z_foils-1.*trigoV[4]*tempV[7])-1.*tempV[1]*(d->y_foil_right+trigoV[9]*tempV[7]))+d->tanCal_right;
d->Tan_AoA_pitch = (-1.*trigoV[2]*d->dx+trigoV[5]*trigoV[3]*d->dy-1.*trigoV[5]*trigoV[7]*d->dz-1.*tempV[0]*d->y_pitch+tempV[2]*d->x_pitch)/(trigoV[6]*trigoV[5]*d->dx+d->dy*trigoV[1]*trigoV[7]+d->dy*trigoV[6]*trigoV[2]*trigoV[3]+d->dz*trigoV[1]*trigoV[3]-1.*d->dz*trigoV[6]*trigoV[2]*trigoV[7]+tempV[2]*d->z_pitch-1.*tempV[1]*d->y_pitch)+d->tanCal_pitch;
d->Tan_AoA_yaw = (trigoV[1]*trigoV[5]*d->dx-1.*tempV[6]-1.*tempV[5]-1.*tempV[1]*d->x_yaw+tempV[0]*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw))/(trigoV[6]*trigoV[5]*d->dx+tempV[4]+tempV[3]+tempV[2]*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*tempV[1]*d->y_yaw)+d->tanCal_yaw;
d->Tan_AoA_sail = (-1.*trigoV[1]*trigoV[5]*d->dx+trigoV[1]*trigoV[5]*d->Wind_x+d->dy*trigoV[6]*trigoV[7]-1.*trigoV[6]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[1]*trigoV[2]*trigoV[3]+trigoV[1]*trigoV[2]*trigoV[3]*d->Wind_y+d->dz*trigoV[6]*trigoV[3]+d->dz*trigoV[1]*trigoV[2]*trigoV[7]+tempV[1]*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*tempV[0]*d->z_sail-1.*(trigoV[6]*trigoV[5]*d->dx-1.*trigoV[6]*trigoV[5]*d->Wind_x+d->dy*trigoV[1]*trigoV[7]-1.*trigoV[1]*trigoV[7]*d->Wind_y+d->dy*trigoV[6]*trigoV[2]*trigoV[3]-1.*trigoV[6]*trigoV[2]*trigoV[3]*d->Wind_y+d->dz*trigoV[1]*trigoV[3]-1.*d->dz*trigoV[6]*trigoV[2]*trigoV[7]+tempV[2]*d->z_sail-1.*tempV[1]*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2)))))*d->tanAngle_sail)/(trigoV[6]*trigoV[5]*d->dx-1.*trigoV[6]*trigoV[5]*d->Wind_x+d->dy*trigoV[1]*trigoV[7]-1.*trigoV[1]*trigoV[7]*d->Wind_y+d->dy*trigoV[6]*trigoV[2]*trigoV[3]-1.*trigoV[6]*trigoV[2]*trigoV[3]*d->Wind_y+d->dz*trigoV[1]*trigoV[3]-1.*d->dz*trigoV[6]*trigoV[2]*trigoV[7]+tempV[2]*d->z_sail-1.*tempV[1]*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2))))+(-1.*trigoV[1]*trigoV[5]*d->dx+trigoV[1]*trigoV[5]*d->Wind_x+d->dy*trigoV[6]*trigoV[7]-1.*trigoV[6]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[1]*trigoV[2]*trigoV[3]+trigoV[1]*trigoV[2]*trigoV[3]*d->Wind_y+d->dz*trigoV[6]*trigoV[3]+d->dz*trigoV[1]*trigoV[2]*trigoV[7]+tempV[1]*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*tempV[0]*d->z_sail)*d->tanAngle_sail);
return; 
} 
 
 
 void forces_all_compute(datas *d) { 
 
double tempV[46]; 
double trigoV[10]; 
 
trigoV[0] = sin(d->psi);
trigoV[1] = sin(d->theta);
trigoV[2] = sin(d->phi);
trigoV[3] = sin(d->alpha_left);
trigoV[4] = sin(d->alpha_right);
trigoV[5] = cos(d->psi);
trigoV[6] = cos(d->theta);
trigoV[7] = cos(d->phi);
trigoV[8] = cos(d->alpha_left);
trigoV[9] = cos(d->alpha_right);
 
tempV[0] = d->dz*trigoV[0]*trigoV[1]*trigoV[7];
tempV[1] = trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y;
tempV[2] = d->dy*trigoV[0]*trigoV[1]*trigoV[2];
tempV[3] = trigoV[5]*trigoV[7]*d->Wind_y;
tempV[4] = trigoV[0]*trigoV[6]*d->Wind_x;
tempV[5] = -1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7];
tempV[6] = trigoV[6]*trigoV[2]*d->Wind_y;
tempV[7] = d->dz*trigoV[5]*trigoV[1]*trigoV[7];
tempV[8] = trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y;
tempV[9] = d->dy*trigoV[5]*trigoV[1]*trigoV[2];
tempV[10] = trigoV[0]*trigoV[7]*d->Wind_y;
tempV[11] = trigoV[5]*trigoV[6]*d->Wind_x;
tempV[12] = trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7];
tempV[13] = d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0];
tempV[14] = d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2)));
tempV[15] = d->dphi*trigoV[1]+d->dpsi;
tempV[16] = -1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_sail;
tempV[17] = d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2)));
tempV[18] = -1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5];
tempV[19] = trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_sail-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2))));
tempV[20] = d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw;
tempV[21] = (trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz;
tempV[22] = (trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy;
tempV[23] = -1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz+(d->dphi*trigoV[1]+d->dpsi)*d->x_yaw-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw);
tempV[24] = (trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz;
tempV[25] = (trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy;
tempV[26] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_yaw;
tempV[27] = trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_pitch-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_pitch;
tempV[28] = trigoV[5]*trigoV[6]*d->dx+d->dy*trigoV[0]*trigoV[7]+d->dy*trigoV[5]*trigoV[1]*trigoV[2]+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_pitch-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_pitch;
tempV[29] = d->Chord_max-1.*d->Chord_min;
tempV[30] = d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max;
tempV[31] = .33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right;
tempV[32] = d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right);
tempV[33] = d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right);
tempV[34] = trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz;
tempV[35] = -1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz;
tempV[36] = trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max));
tempV[37] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right));
tempV[38] = pow((trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))),2)+pow((trigoV[9]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)-1.*trigoV[4]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[9]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))-1.*trigoV[4]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2)+pow((trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2);
tempV[39] = d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max;
tempV[40] = -.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left;
tempV[41] = d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left);
tempV[42] = d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left);
tempV[43] = -1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max));
tempV[44] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left));
tempV[45] = pow((trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))),2)+pow((trigoV[8]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[3]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[8]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[3]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2)+pow((-1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2);
 
d->Force_left[0] = sqrt(tempV[45])*(-1.*d->A_left*d->rho*d->CD_left*tempV[44]-1.*d->A_left*d->rho*d->CL_left*tempV[43]);
d->Force_left[1] = sqrt(tempV[45])*(-1.*d->A_left*d->rho*trigoV[3]*d->CL_left*tempV[44]+d->A_left*d->rho*trigoV[3]*d->CD_left*tempV[43]);
d->Force_left[2] = sqrt(tempV[45])*(d->A_left*d->rho*trigoV[8]*d->CL_left*tempV[44]-1.*d->A_left*d->rho*trigoV[8]*d->CD_left*tempV[43]);
d->Force_right[0] = sqrt(tempV[38])*(-1.*d->A_right*d->rho*d->CD_right*tempV[37]-1.*d->A_right*d->rho*d->CL_right*tempV[36]);
d->Force_right[1] = sqrt(tempV[38])*(d->A_right*d->rho*trigoV[4]*d->CL_right*tempV[37]-1.*d->A_right*d->rho*trigoV[4]*d->CD_right*tempV[36]);
d->Force_right[2] = sqrt(tempV[38])*(d->A_right*d->rho*trigoV[9]*d->CL_right*tempV[37]-1.*d->A_right*d->rho*trigoV[9]*d->CD_right*tempV[36]);
d->Force_pitch[0] = sqrt((pow(tempV[28],2)+pow((-1.*trigoV[0]*trigoV[6]*d->dx+d->dy*trigoV[5]*trigoV[7]-1.*tempV[2]+d->dz*trigoV[5]*trigoV[2]+tempV[0]+tempV[15]*d->x_pitch-1.*tempV[13]*d->z_pitch),2)+pow(tempV[27],2)))*(-1.*d->rho*d->A_pitch*d->CD_pitch*tempV[28]-1.*d->rho*d->A_pitch*d->CL_pitch*tempV[27]);
d->Force_pitch[1] = 0.;
d->Force_pitch[2] = sqrt((pow(tempV[28],2)+pow((-1.*trigoV[0]*trigoV[6]*d->dx+d->dy*trigoV[5]*trigoV[7]-1.*tempV[2]+d->dz*trigoV[5]*trigoV[2]+tempV[0]+tempV[15]*d->x_pitch-1.*tempV[13]*d->z_pitch),2)+pow(tempV[27],2)))*(d->rho*d->A_pitch*d->CL_pitch*tempV[28]-1.*d->rho*d->A_pitch*d->CD_pitch*tempV[27]);
d->Force_yaw[0] = sqrt((pow(tempV[26],2)+pow(tempV[23],2)+pow((trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+tempV[13]*d->y_yaw-1.*tempV[18]*d->x_yaw),2)))*(-1.*d->rho*d->A_yaw*d->CD_yaw*tempV[26]-1.*d->rho*d->A_yaw*d->CL_yaw*tempV[23]);
d->Force_yaw[1] = sqrt((pow(tempV[26],2)+pow(tempV[23],2)+pow((trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+tempV[13]*d->y_yaw-1.*tempV[18]*d->x_yaw),2)))*(d->rho*d->A_yaw*d->CL_yaw*tempV[26]-1.*d->rho*d->A_yaw*d->CD_yaw*tempV[23]);
d->Force_yaw[2] = 0.;
d->Force_sail[0] = sqrt((pow(tempV[19],2)+pow(tempV[16],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[6]+trigoV[6]*trigoV[7]*d->dz+tempV[13]*tempV[17]-1.*tempV[18]*tempV[14]),2)))*(-1.*d->rho_air*d->A_sail*d->CD_sail*tempV[19]+d->rho_air*d->A_sail*d->CL_sail*tempV[16]);
d->Force_sail[1] = sqrt((pow(tempV[19],2)+pow(tempV[16],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[6]+trigoV[6]*trigoV[7]*d->dz+tempV[13]*tempV[17]-1.*tempV[18]*tempV[14]),2)))*(-1.*d->rho_air*d->A_sail*d->CL_sail*tempV[19]-1.*d->rho_air*d->A_sail*d->CD_sail*tempV[16]);
d->Force_sail[2] = 0.;
d->Force_drag[0] = -1.*sqrt((pow(tempV[12],2)+pow(tempV[5],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[6]+trigoV[6]*trigoV[7]*d->dz),2)))*d->rho_air*d->A_structure*d->CD_structure*tempV[12];
d->Force_drag[1] = -1.*sqrt((pow(tempV[12],2)+pow(tempV[5],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[6]+trigoV[6]*trigoV[7]*d->dz),2)))*d->rho_air*d->A_structure*d->CD_structure*tempV[5];
d->Force_drag[2] = 0.;
return; 
} 
 
 
 void forces_compute(datas *d) { 
 
double tempV[61]; 
double trigoV[10]; 
 
trigoV[0] = sin(d->psi);
trigoV[1] = sin(d->theta);
trigoV[2] = sin(d->phi);
trigoV[3] = sin(d->alpha_left);
trigoV[4] = sin(d->alpha_right);
trigoV[5] = cos(d->psi);
trigoV[6] = cos(d->theta);
trigoV[7] = cos(d->phi);
trigoV[8] = cos(d->alpha_left);
trigoV[9] = cos(d->alpha_right);
 
tempV[0] = d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw;
tempV[1] = d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0];
tempV[2] = d->dphi*trigoV[1]+d->dpsi;
tempV[3] = (trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz;
tempV[4] = (trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy;
tempV[5] = -1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz+(d->dphi*trigoV[1]+d->dpsi)*d->x_yaw-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw);
tempV[6] = -1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5];
tempV[7] = (trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz;
tempV[8] = (trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy;
tempV[9] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_yaw;
tempV[10] = -1.*d->rho*d->A_yaw*d->CD_yaw*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_yaw)-1.*d->rho*d->A_yaw*d->CL_yaw*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz+(d->dphi*trigoV[1]+d->dpsi)*d->x_yaw-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw));
tempV[11] = pow((trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_yaw),2)+pow((-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz+(d->dphi*trigoV[1]+d->dpsi)*d->x_yaw-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)),2)+pow((trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_yaw-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_yaw),2);
tempV[12] = d->rho*d->A_yaw*d->CL_yaw*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw)-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_yaw)-1.*d->rho*d->A_yaw*d->CD_yaw*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz+(d->dphi*trigoV[1]+d->dpsi)*d->x_yaw-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_yaw-.50000000000000000000000000000000*d->E_yaw-.50000000000000000000000000000000*d->EE_yaw));
tempV[13] = trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_pitch-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_pitch;
tempV[14] = d->dz*trigoV[5]*trigoV[1]*trigoV[7];
tempV[15] = d->dy*trigoV[5]*trigoV[1]*trigoV[2];
tempV[16] = trigoV[5]*trigoV[6]*d->dx+d->dy*trigoV[0]*trigoV[7]+d->dy*trigoV[5]*trigoV[1]*trigoV[2]+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_pitch-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_pitch;
tempV[17] = -1.*d->rho*d->A_pitch*d->CD_pitch*(trigoV[5]*trigoV[6]*d->dx+d->dy*trigoV[0]*trigoV[7]+d->dy*trigoV[5]*trigoV[1]*trigoV[2]+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_pitch-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_pitch)-1.*d->rho*d->A_pitch*d->CL_pitch*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_pitch-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_pitch);
tempV[18] = d->dz*trigoV[0]*trigoV[1]*trigoV[7];
tempV[19] = d->dy*trigoV[0]*trigoV[1]*trigoV[2];
tempV[20] = pow((trigoV[5]*trigoV[6]*d->dx+d->dy*trigoV[0]*trigoV[7]+d->dy*trigoV[5]*trigoV[1]*trigoV[2]+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_pitch-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_pitch),2)+pow((-1.*trigoV[0]*trigoV[6]*d->dx+d->dy*trigoV[5]*trigoV[7]-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*d->x_pitch-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_pitch),2)+pow((trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_pitch-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_pitch),2);
tempV[21] = d->Chord_max-1.*d->Chord_min;
tempV[22] = d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max;
tempV[23] = .33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right;
tempV[24] = d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right);
tempV[25] = d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right);
tempV[26] = trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz;
tempV[27] = -1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz;
tempV[28] = trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max));
tempV[29] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right));
tempV[30] = -1.*d->A_right*d->rho*d->CD_right*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))-1.*d->A_right*d->rho*d->CL_right*(trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[31] = pow((trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))),2)+pow((trigoV[9]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)-1.*trigoV[4]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[9]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))-1.*trigoV[4]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2)+pow((trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2);
tempV[32] = d->A_right*d->rho*trigoV[4]*d->CL_right*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))-1.*d->A_right*d->rho*trigoV[4]*d->CD_right*(trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[33] = d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max;
tempV[34] = -.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left;
tempV[35] = d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left);
tempV[36] = d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left);
tempV[37] = -1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max));
tempV[38] = trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left));
tempV[39] = -1.*d->A_left*d->rho*d->CD_left*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))-1.*d->A_left*d->rho*d->CL_left*(-1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[40] = pow((trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))),2)+pow((trigoV[8]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[3]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[8]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[3]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2)+pow((-1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max))),2);
tempV[41] = -1.*d->A_left*d->rho*trigoV[3]*d->CL_left*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+d->A_left*d->rho*trigoV[3]*d->CD_left*(-1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[42] = d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2)));
tempV[43] = trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y;
tempV[44] = trigoV[5]*trigoV[7]*d->Wind_y;
tempV[45] = trigoV[0]*trigoV[6]*d->Wind_x;
tempV[46] = -1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_sail;
tempV[47] = d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2)));
tempV[48] = trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y;
tempV[49] = trigoV[0]*trigoV[7]*d->Wind_y;
tempV[50] = trigoV[5]*trigoV[6]*d->Wind_x;
tempV[51] = trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_sail-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2))));
tempV[52] = -1.*d->rho_air*d->A_sail*d->CD_sail*(trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_sail-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2)))))+d->rho_air*d->A_sail*d->CL_sail*(-1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_sail);
tempV[53] = trigoV[6]*trigoV[2]*d->Wind_y;
tempV[54] = pow((trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_sail-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2))))),2)+pow((-1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_sail),2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[2]*d->Wind_y+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))),2);
tempV[55] = -1.*d->rho_air*d->A_sail*d->CL_sail*(trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_sail-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_sail-.33333333333333333333333333333333*d->Baume*d->tanAngle_sail/sqrt((1.+pow(d->tanAngle_sail,2)))))-1.*d->rho_air*d->A_sail*d->CD_sail*(-1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7]+(d->dphi*trigoV[1]+d->dpsi)*(d->x_sail-.33333333333333333333333333333333*d->Baume/sqrt((1.+pow(d->tanAngle_sail,2))))-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->z_sail);
tempV[56] = d->rho*d->A_pitch*d->CL_pitch*(trigoV[5]*trigoV[6]*d->dx+d->dy*trigoV[0]*trigoV[7]+d->dy*trigoV[5]*trigoV[1]*trigoV[2]+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7]+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->z_pitch-1.*(d->dphi*trigoV[1]+d->dpsi)*d->y_pitch)-1.*d->rho*d->A_pitch*d->CD_pitch*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz+(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*d->y_pitch-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*d->x_pitch);
tempV[57] = d->A_right*d->rho*trigoV[9]*d->CL_right*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))-1.*d->A_right*d->rho*trigoV[9]*d->CD_right*(trigoV[4]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[9]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)+trigoV[4]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils-1.*trigoV[4]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right)))+trigoV[9]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_right+trigoV[9]*(.33333333333333333333333333333333*d->E_foils+.66666666666666666666666666666667*d->EE_right))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_right*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[58] = d->A_left*d->rho*trigoV[8]*d->CL_left*(trigoV[5]*trigoV[6]*d->dx+(trigoV[0]*trigoV[7]+trigoV[5]*trigoV[1]*trigoV[2])*d->dy+(trigoV[0]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[7])*d->dz+(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(d->dphi*trigoV[1]+d->dpsi)*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))-1.*d->A_left*d->rho*trigoV[8]*d->CD_left*(-1.*trigoV[3]*(-1.*trigoV[0]*trigoV[6]*d->dx+(trigoV[5]*trigoV[7]-1.*trigoV[0]*trigoV[1]*trigoV[2])*d->dy+(trigoV[5]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[7])*d->dz)+trigoV[8]*(trigoV[1]*d->dx-1.*trigoV[6]*trigoV[2]*d->dy+trigoV[6]*trigoV[7]*d->dz)-1.*trigoV[3]*((d->dphi*trigoV[1]+d->dpsi)*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)-1.*(d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->z_foils+trigoV[3]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left)))+trigoV[8]*((d->dphi*trigoV[5]*trigoV[6]+d->dtheta*trigoV[0])*(d->y_foil_left+trigoV[8]*(-.33333333333333333333333333333333*d->E_foils-.66666666666666666666666666666667*d->EE_left))-1.*(-1.*d->dphi*trigoV[0]*trigoV[6]+d->dtheta*trigoV[5])*(d->x_foils+.33333333333333333333333333333333*d->EE_left*(d->Chord_max-1.*d->Chord_min)/d->E_foils-.33333333333333333333333333333333*d->Chord_max)));
tempV[59] = -1.*trigoV[0]*trigoV[6]*d->dx+trigoV[0]*trigoV[6]*d->Wind_x+d->dy*trigoV[5]*trigoV[7]-1.*trigoV[5]*trigoV[7]*d->Wind_y-1.*d->dy*trigoV[0]*trigoV[1]*trigoV[2]+trigoV[0]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[5]*trigoV[2]+d->dz*trigoV[0]*trigoV[1]*trigoV[7];
tempV[60] = trigoV[5]*trigoV[6]*d->dx-1.*trigoV[5]*trigoV[6]*d->Wind_x+d->dy*trigoV[0]*trigoV[7]-1.*trigoV[0]*trigoV[7]*d->Wind_y+d->dy*trigoV[5]*trigoV[1]*trigoV[2]-1.*trigoV[5]*trigoV[1]*trigoV[2]*d->Wind_y+d->dz*trigoV[0]*trigoV[2]-1.*d->dz*trigoV[5]*trigoV[1]*trigoV[7];
 
d->Force_G_E1 = -1.*sqrt((pow(tempV[60],2)+pow(tempV[59],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[53]+trigoV[6]*trigoV[7]*d->dz),2)))*d->rho_air*d->A_structure*d->CD_structure*tempV[60]+sqrt(tempV[54])*tempV[52]+sqrt(tempV[40])*tempV[39]+sqrt(tempV[31])*tempV[30]+sqrt(tempV[20])*tempV[17]+sqrt(tempV[11])*tempV[10];
d->Force_G_E2 = -1.*sqrt((pow(tempV[60],2)+pow(tempV[59],2)+pow((trigoV[1]*d->dx-1.*trigoV[1]*d->Wind_x-1.*trigoV[6]*trigoV[2]*d->dy+tempV[53]+trigoV[6]*trigoV[7]*d->dz),2)))*d->rho_air*d->A_structure*d->CD_structure*tempV[59]+sqrt(tempV[54])*tempV[55]+sqrt(tempV[40])*tempV[41]+sqrt(tempV[31])*tempV[32]+sqrt(tempV[11])*tempV[12];
d->Force_G_E3 = sqrt(tempV[40])*tempV[58]+sqrt(tempV[31])*tempV[57]+sqrt(tempV[20])*tempV[56];
d->Torque_G_E1 = -1.*d->z_sail*sqrt(tempV[54])*tempV[55]+tempV[35]*sqrt(tempV[40])*tempV[58]-1.*tempV[36]*sqrt(tempV[40])*tempV[41]+tempV[24]*sqrt(tempV[31])*tempV[57]-1.*tempV[25]*sqrt(tempV[31])*tempV[32]+d->y_pitch*sqrt(tempV[20])*tempV[56]-1.*tempV[0]*sqrt(tempV[11])*tempV[12];
d->Torque_G_E2 = d->z_sail*sqrt(tempV[54])*tempV[52]+tempV[36]*sqrt(tempV[40])*tempV[39]-1.*tempV[33]*sqrt(tempV[40])*tempV[58]+tempV[25]*sqrt(tempV[31])*tempV[30]-1.*tempV[22]*sqrt(tempV[31])*tempV[57]+d->z_pitch*sqrt(tempV[20])*tempV[17]-1.*d->x_pitch*sqrt(tempV[20])*tempV[56]+tempV[0]*sqrt(tempV[11])*tempV[10];
d->Torque_G_E3 = tempV[42]*sqrt(tempV[54])*tempV[55]-1.*tempV[47]*sqrt(tempV[54])*tempV[52]+tempV[33]*sqrt(tempV[40])*tempV[41]-1.*tempV[35]*sqrt(tempV[40])*tempV[39]+tempV[22]*sqrt(tempV[31])*tempV[32]-1.*tempV[24]*sqrt(tempV[31])*tempV[30]-1.*d->y_pitch*sqrt(tempV[20])*tempV[17]+d->x_yaw*sqrt(tempV[11])*tempV[12]-1.*d->y_yaw*sqrt(tempV[11])*tempV[10];
return; 
} 
 
 
