/**
* \file aero_coeff_control.cpp
* \author basile.graf@epfl.ch
* 
* This file contains stuff related to Lift and Drag computation... 
*/


#include "math.h"
#include "mex.h"  
#include "string.h"

#include "Datas.h"
#include "aero_coeff_control.h"


#ifndef PI_DEF
#define pi 3.141592653589793
#define PI 3.141592653589793
#endif


void aero_coeff_control(datas *d)
{
	d->Chord_right = d->Chord_max - (d->Chord_max - d->Chord_min)*(d->EE_right/d->E_foils);
	d->Chord_left = d->Chord_max - (d->Chord_max - d->Chord_min)*(d->EE_left/d->E_foils);

	d->A_left = 0.5*(d->Chord_left + d->Chord_min)*(d->E_foils - d->EE_left);
	d->A_right = 0.5*(d->Chord_right + d->Chord_min)*(d->E_foils - d->EE_right);
	d->A_yaw = d->Chord*(d->E_yaw - d->EE_yaw);

	d->AR_left = (pow(d->E_foils-d->EE_left,2))/d->A_left;
	d->AR_right = (pow(d->E_foils-d->EE_right,2))/d->A_right;

	d->AR_yaw = d->A_yaw/pow(d->Chord,2);
	d->AR_pitch = d->A_pitch/pow(d->Chord,2);

	d->AR_sail = 4.4;

//%Lift reduction due to AR is supposed polynomial, degree gamma

	d->gamma = 1;


	d->CL_left = (1 - pow((d->EE_left/d->E_foils),d->gamma))*6.3802*d->Tan_AoA_left;
	d->CD_left = 0.00485054892829 + 0.09060697805806*pow(d->Tan_AoA_left,2) + 0.5*pow(d->CL_left,2)/(pi*d->AR_left);

	d->CL_right = (1 - pow(d->EE_right/d->E_foils,d->gamma))*6.3802*d->Tan_AoA_right;
	d->CD_right = 0.00485054892829 + 0.09060697805806*pow(d->Tan_AoA_right,2) + 0.5*pow(d->CL_right,2)/(pi*d->AR_right);

	d->CL_yaw = 6.3802*d->Tan_AoA_yaw;
	d->CD_yaw = 0.00485054892829 + 0.09060697805806*pow(d->Tan_AoA_yaw,2) + 0.5*pow(d->CL_yaw,2)/(pi*d->AR_yaw);

	d->CL_pitch = 6.3802*d->Tan_AoA_pitch;
	d->CD_pitch = 0.00485054892829 + 0.09060697805806*pow(d->Tan_AoA_pitch,2) + pow(d->CL_pitch,2)/(pi*d->AR_pitch);

//%CL_sail = 2*Tan_AoA_sail;//%tanCal_sail;
//%CD_sail = 0.009 + 0.02*Tan_AoA_sail + 0.26*Tan_AoA_sail^2;//% + CL_sail^2/(pi*AR_sail);

	d->CL_sail = 1*d->Tan_AoA_sail;//%tanCal_sail;
	d->CD_sail = 0.0044 + 0.0102*d->Tan_AoA_sail + 0.1285*pow(d->Tan_AoA_sail,2);//% + CL_sail^2/(pi*AR_sail);
}