/**
* \file return_mex_arguments.h
* \author basile.graf@epfl.ch
* 
* This file contains functions for returning parameters to MATLAB
*/


#ifndef RETURN_MEX_ARGUMENTS_H_DEF
#define RETURN_MEX_ARGUMENTS_H_DEF

#include "math.h"
#include "mex.h"  
#include "string.h"


/// Store state vector \f$ \vec{q}_i \f$ and time \f$ t_i \f$ at each integration step
/**
* If the programm has to return simulation results to MATLAB (see get_time()), 
* the state vector \f$ \vec{q}_i \f$ and the time \f$ t_i \f$ has to be stored at each integration step. 
* They are stored in dynamic C++ vectors of type vector.
* \param time \f$ t_i \f$
* \param state_at_t \f$ \vec{q}_i \f$ in the data format used by the SUNDIALS ODE solver CVODE
*/
void store_state(double time, N_Vector state_at_t);


/// Return arguments to MATLAB
/**
* Return the simulation results and simulation times (if asked for, see get_time()) and the cumulative number 
* of integration steps performed (generally bigger than number of output points)
* \param nlhs Number of left hand side arguments in the MATLAB prompt
* \param *plhs[] Array of pointers to the left hand side arguments from MATLAB prompt
* \param nrhs Number of right hand side arguments in the MATLAB prompt
* \param *prhs[] Array of pointers to the right hand side arguments from MATLAB prompt
* \param *f_dat ODE solver data struct
*/
void return_args(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[], ODE_data *f_dat);


#endif