/**
* \file Datas.h
* \author basile.graf@epfl.ch
* 
* This file contains declaration for different data-structures used globaly
*/


#ifndef DATAS_H_DEF
#define DATAS_H_DEF


#include "../CVODEincludes.h"  // ODE solver includes



/// parameters struct declaration
/**
* These parameters are passed by MATLAB
*/
struct parameters
{
//	double x0;
//	double y0;
//	double z0;
//	double alpha_cam;
//	double beta_cam;
//	double x_rel;
//	double y_rel;
//	double z_rel;
//	double Gain;
//	double time_stop;
	double reltol;
	double abstol[12];
	double param[10];
};


/// datas struct declaration
/**
* datas contains all variables related to the model (a lot) plus some other. \n
* Many functions take a pointer *d to this struct 
*/
struct datas
{
	double x_foils;
	double tanCal_yaw0;
	double tanAngle_sail;
	double G_shift;
	double alpha_foils;
	double Wind_angle;
	double z_foils;

	double g;

	double Long;

	double tanCal_left; //Max LD
	double tanCal_right;
	double tanCal_pitch;

	double alpha_left;
	double alpha_right;

	double y_foil_left;
	double y_foil_right;

	double L_mast;

	double x_sail;
	double y_sail;
	double z_sail;
	double A_sail;
	double Baume;
	double A_structure;
	double CD_structure;

	double Ix; 
	double Iy;
	double Iz;
	double M;

	double E_foils;
	double Chord;

	//Min & max chord for the hydrofoils
	double Chord_min;
	double Chord_max;
	double epsilon;

	double rho;
	double rho_air;

	double E_yaw; //2;

	double Env_pitch;

	double Chord_yaw;
	double Chord_pitch;

	double A_pitch; 

	double x_yaw;
	double y_yaw;
	double z_yaw; //E_yaw/2 - 5;

	double x_pitch;
	double y_pitch;
	double z_pitch;

	double Wind;
	double Wind_x;
	double Wind_y;

	double Env;

	double Lambda0;
	double Wave_angle0;
	double Wave_amp0;
	double V_wave0;

	double Lambda[2];     
	double Wave_angle[2];  
	double Wave_amp[2];   
	double V_wave[2];   

	int N; //length(Lambda);

	double Lambda1; 
	double Lambda2; 
	double Wave_amp1;  
	double Wave_amp2; 
	double V_wave1;  
	double V_wave2;   
	double Wave_angle1; 
	double Wave_angle2;  

//suite de Hydro_integ.m
	double x;
	double y; 
	double z; 

	double phi; 
	double theta; 
	double psi; 

	double dx;
	double dy; 
	double dz; 

	double dphi; 
	double dtheta;
	double dpsi;

	double x_cam;
	double y_cam;
	double z_cam;

	double dx_cam;
	double dy_cam;
	double dz_cam;
//

	double tanCal_yaw;


	//variables for EE_Flat	
	double EE_left;
	double EE_right;
	double EE_yaw;
	double EE_left_flat;
	double EE_right_flat;
	double EE_yaw_flat;


	double Fac_update;

	//variables for Equ
	double Equ_left;
	double Equ_right;
	double Equ_yaw;
	double dEqu_left;
	double dEqu_right;
	double dEqu_yaw;

	int k;

	//variables for Angle
	double Tan_AoA_left;
	double Tan_AoA_right;
	double Tan_AoA_pitch;
	double Tan_AoA_yaw;
	double Tan_AoA_sail;

	//variables for forces
	double Force_G_E1;
	double Force_G_E2;
	double Force_G_E3;
	double Torque_G_E1;
	double Torque_G_E2;
	double Torque_G_E3;

	//variables for forces_all
	double Force_left[3];
	double Force_right[3];
	double Force_pitch[3];
	double Force_yaw[3];
	double Force_sail[3];
	double Force_drag[3];

	//variables for acceleration
	double ddq[6];

//	double *t_array; 
//	long tLength;// length of t_array


	//MISSING VARIABLES ????: from generated functions
	double t;
	double A_left; 
	double CD_left; 
	double CL_left; 
	double CD_right;
	double A_right; 
	double CL_right;
	double CD_pitch;
	double CL_pitch;
	double A_yaw; 
	double CD_yaw;
	double CL_yaw;
	double CD_sail; 
	double CL_sail;


	//variables for aero_coeff_control
	double Chord_right;
	double Chord_left;
	double AR_left;
	double AR_right;
	double AR_yaw;
	double AR_pitch;
	double AR_sail;
	double gamma;

	//variables for system definition
	double dd_cam[3];
	double d_cam[3];


	//for drawing
	double L_nose;


	//verifications:
	double verif[26];

	float target_x, target_y;
	float Vslider_x, Hslider_x;

	//Neutrel cal angles as given in P->param[] vector (from MATLAB):
	double Cal_left_neutral;
	double Cal_right_neutral;
	double Cal_pitch_neutral;
	double Cal_yaw_neutral;

	//Baume control:
	double angle_girouette;
	double max_abs_angle_baume;

};



/// Datas relative to the ODE solver
/**
* Contains data for the solver and pointers to the general structure datas *d 
* as well as a pointer to parameters *P.
*/
struct ODE_data
{
	double *state;
	parameters *P;
	datas *d;

	//time_param=0.0 => no output
	//time_param=t   => simulation from 0 to t and give state back to MATLAB
	double time_param;

//	double *XoutArray;
	double CumulNumOfSteps; //type double for returning to MATLAB, but integer value
	///< Cumulative number of integration steps


	realtype reltol, t, tout;
	N_Vector y, abstol;
	void *cvode_mem;
	int flag, flagr, iout;
	int rootsfound[2];
};


/// Struct for joystick things
/**
* Variables from MATLAB (or default) to indicate how to use the joystick (if any)
*/
struct joy_parameters
{
	bool doX;	///< TRUE: use jostick X-axis, FALSE: use keyboard
	bool doY;	///< TRUE: use jostick Y-axis, FALSE: use keyboard
	bool doZ;	///< TRUE: use jostick Z-axis, FALSE: use keyboard
	bool doR;	///< TRUE: use jostick R-axis, FALSE: use keyboard

	float dirX;  ///< change X axis direction: -1.0f
	float dirY;  ///< change Y axis direction: -1.0f
	float dirZ;  ///< change Z axis direction: -1.0f
	float dirR;  ///< change R axis direction: -1.0f
};

#endif