/**
* \file CVODEincludes.h
* \author basile.graf@epfl.ch
* 
* This file contains all includes for the SUNDIALS CVODE solver. Documentation for CVODE is not 
* included here, see: \n
* http://www.llnl.gov/casc/sundials/documentation/documentation.html \n
* for CVODE documentation
*/


#ifndef CVODE_INCLUDES_H_DEF
#define CVODE_INCLUDES_H_DEF

//-------------Includes for SUNDIALS CVODE solver:---------------------------------
#include "CVODE/cvode.h"          /* prototypes for CVODE fcts. and consts. */
#include "CVODE/nvector_serial.h" /* serial N_Vector types, fcts., and macros */
#include "CVODE/cvode_dense.h"    /* prototype for CVDense */
#include "CVODE/cvode_diag.h"    /* prototype for CVDiag */
#include "CVODE/sundials_dense.h" /* definitions DenseMat DENSE_ELEM */
#include "CVODE/sundials_types.h" /* definition of type realtype */
//---------------------------------------------------------------------------------

#endif