#ifndef JOYSTICK_SDL_H_DEF
#define JOYSTICK_SDL_H_DEF

/// Initializes joystick stuff
/**
* SDL joystick init (if any connected)
*/
int joystick_init();

/// Get joystick position with SDL
/**
* Get the joystick positions for the axes specified. Values should be between -1.0 and 1.0
* \param *X pointer to the X axis variable
* \param *Y pointer to the Y axis variable
* \param *Z pointer to the Z axis variable
* \param *R pointer to the R axis variable
* \param doX modify X value only if true 
* \param doY modify Y value only if true 
* \param doZ modify Z value only if true 
* \param doR modify R value only if true 
*/
void joystick_getXYZR(float *X, float *Y, float *Z, float *R, bool doX, bool doY, bool doZ, bool doR);


/// Close joystick 
/**
* No need to close anything under Windows => this function does nothing...
*/
void joystick_close();

int is_there_a_joystick();

#endif

