/**
* \file graphics_relative.h
* \author basile.graf@epfl.ch
* 
* This file contains includes for graphical purposes and declarations for some graphic related functions 
*/



#ifndef GRAPHIC_RELATIVE_H_DEF
#define GRAPHIC_RELATIVE_H_DEF

/*
// c********* Includes for openGL compilation under Windows ************
#include <windows.h>								// Header File For Windows
#include <stdio.h>	
#include <stdarg.h>						// Header File For Variable Argument Routines	
#include <GL\glut.h>
#include <GL\gl.h>								// Header File For The OpenGL32 Library
#include <GL\glu.h>								// Header File For The GLu32 Library
#include <GL\glaux.h>

#include "../joystick/joystick_PC.h"
// c*********************************************************************

// c********  Includes for openGL compilation under Mac *****************
// c*********************************************************************
*/
#include "SDL.h"
#include "SDL_OpenGL.h"
#include "SDL_ttf/SDL_ttf.h"   
//:For display fonts


#include "../main.h"

#include "../hydro_source/Datas.h"
//#include "boat.h"
#include "Sea.h"

#include "solid_objects.h"

#include "../joystick_SDL/joystick_SDL.h"


//PROVISOIRE AVEC QUIT_TUTORIAL():
//#include "f.h"
//#include "CVODEincludes.h"
#include "../hydro_source/hydro_includes.h"

//Faudra faire ca joli:
//static void quit_tutorial( int code ) ;
GLuint* get_texture();
bool getCallibatingPhase();
void resize_window(int height, int width);
void setup_opengl(int width, int height);
void setup_SDL(int width, int height); 
void process_events( void );
void handle_key_down( SDL_keysym* keysym );
void do_on_keystate(datas *d);
void setup_font();
void close_font();


// c******** declarations for graphics_main.cpp *************************
//LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
//GLvoid ReSizeGLScene(GLsizei width, GLsizei height);

/// Initialize OpenGL stuff
/**
* Initialize OpenGL stuff like lighting, material apperance, etc... \n
* Build font for OSD (On Screen Display) also. (MS Windows dependent!)
*/
//int InitGL(GLvoid);

/// Draws the scene (openGL)
/**
* Draws the scene by appling all necessary geometrical (spacial) transformations and by calling
* the different element drawing functions (for the boat, the sea, the instruments...). This is not the highest
* function for drwaing the current scene, see draw_graphics().
*/
int DrawGLScene(datas* d);//, graphicDatas *gd);//int DrawGLScene(datas *d, seaDatas *sd, boatDatas *bd);
//GLvoid KillGLWindow(GLvoid);

/// Sub-function for window closing stuffs
//bool CreateGLWindow(char* title, int width, int height, int bits, bool fullscreenflag);

/// General graphic stuff initialisation
/**
* Ask for full-screen or not, creates window and try to initialize the joystick.
* \param *d : pointer to the datas data-structure
* \return 1 if window created sucessfully
*/
//int draw_graphics_init(datas *d);//, graphicDatas *gd);

/// General graphic (scene) display and keyboard reading
/**
* A call to this function refreshes the entire scene. This function is to be used in the main 
* computing loop. \n
* It also reads the keyboard for the different keyboard controls...
* \param *d : pointer to the datas data-structure
* \return true if all went OK
*/
//bool draw_graphics(datas *d);//, graphicDatas *gd);


/// General graphic (scene/window) closing
/**
* Closes window and joystick
* \return msg.wParam (MS Windows !)
*/
//int draw_graphics_kill();//graphicDatas *gd);

/// Copy joystick parameters from MATLAB struct
/**
* Copy the joystick parameters (doX, doY ,doZ ,doR and dirX ,dirY ,diZ ,dirR) from the MATLAB struct *jP
* to the local joystick parameters variables.
* \param *jP : Structure comming from MATLAB or filled with default values defining joystick axes usage and direction.
*/
void pass_joy_parameters(joy_parameters *jP);
// c*********************************************************************

#endif