%Author: Dominic Rfenacht, IVRG, EPFL, September 2012
%Purpose: Computes the accuracy of a shadow mask compared to the
%groundtruth. The two maps need to have the same dimensions.

function [tp fp tn fn accuracy] = compute_accuracy(shadow_mask, groundtruth)
diff = groundtruth - shadow_mask;

tp = length(intersect(find(diff == 0), find(groundtruth == 1)));
fp = length(find(diff == -1));
fn = length(find(diff == 1));
tn = length(intersect(find(diff == 0), find(groundtruth == 0)));

accuracy = (tp + tn) / (tp + tn + fp + fn);

if ((length(find(diff == 0)) - tp - tn) ~= 0)
    error('tp + fp not correct');
end