function out = wb(CFAim,coefs,camera)
% function wb
% 
% Performs white balancing on a canon 350D CFA image with the given filter
% coefficients
%
% CFAim: input CFA images, stacked into the 3rd dimension (:,:,nImages)
% coefs: 3 white-balancing coefficients. [R G B]. G is usually set to 1.
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: November 22, 2007, by Daniel Tamburrino

[s1 s2 s3] = size(CFAim);
% Create masks
switch (upper(camera))
    case '350D' % Canon 350D, aka Rebell XT
        % Canon 350D Bayer pattern
        % R G R G R G
        % G B G B G B
        % R G R G R G
        % B G B G B G
        % Red Channel
        mR=ones(s1,s2);
        mR(1:2:end,2:2:end)=0;
        mR(2:2:end,1:end)=0;
        mR=coefs(1)*mR;

        % Green Channel
        mG=ones(s1,s2);
        mG(1:2:end,1:2:end)=0;
        mG(2:2:end,2:2:end)=0;
        mG=coefs(2)*mG;

        % Blue channel
        mB=ones(s1,s2);
        mB(1:2:end,2:2:end)=0;
        mB(1:end,1:2:end)=0;
        mB=coefs(3)*mB;
    otherwise
        error('wb: unknown bayer pattern for this camera');
end

for i=1:s3
    CFAim(:,:,i)=(mR+mG+mB).*CFAim(:,:,i);
end
out=CFAim;
