function coefs = setWB(image,camera)
% function setWB
% 
% Sets the White balance coefficients
%
% IN
%   image: single input CFA image
%   camera: camera model. '350D' supported
% OUT
%   coefs: 3 white-balancing coefficients. [R G B]. G is usually set to 1.
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: November 23, 2007, by Daniel Tamburrino

% Create masks
switch (upper(camera))
    case '350D' % Canon 350D, aka Rebell XT
        % Canon 350D Bayer pattern (landscape only)
        % R G R G R G
        % G B G B G B
        % R G R G R G
        % G B G B G B
        
        pSize=3; % size of gray area
        pNumber=1; % patch number
        
        figure, imshow(image.^0.2,[]), title('>>>>>>>>>>SELECT A MIDDLE GRAY AREA<<<<<<<<<<')
        [x1 x2]=ginput(pNumber); % x and y coordinates are inversed in matlab
        close
        x1=round(x1);
        x2=round(x2);
        
        % compute mean R, G and B values
        % Note: x2 comes before x1 in matlab notation
        if and(mod(x1,2)==1,mod(x2,2)==1) % Red pixel
            %do nothing
        elseif and(mod(x1,2)==0,mod(x2,2)==0) % Blue pixel
            %offset by (1,1)
            x1=x1+1;
            x2=x2+1;
        elseif and(mod(x1,2)==1,mod(x2,2)==0)
            %offset by (0,1)
            x2=x2+1;
        elseif and(mod(x1,2)==0,mod(x2,2)==1)
            %offset by (1,0)
            x1=x1+1;
        end
        
        % one pixel
%         R=image(x2,x1);
%         G=image(x2+1,x1);
%         B=image(x2+1,x1+1);
        
        % three pixel mean
        R=mean(image(x2,x1)+image(x2+2,x1)+image(x2,x1+2));
        G=mean(image(x2+1,x1)+image(x2+2,x1+1)+image(x2,x1+1));
        B=mean(image(x2+1,x1+1)+image(x2+3,x1+1)+image(x2+1,x1+3));
        
        coefs = [R G B].^(-1);
        coefs = coefs/coefs(2)
        
    otherwise
        error('setWB: unknown bayer pattern for this camera');
end


