% Modify this file to run the algorithm with different parameters
% Read the ReadMe.txt file for operation instructions
%
%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: February 04, 2008, by Daniel Tamburrino

close all
clear all

%% Parameters

global DISPLAY % Display intermediate results

global CAMERA % Camera model (only for full workflow). Currently supported: '350D' aka Canon Rebel XT

global FILTER_HORI % Sigma_H value for filtering in Horizontal cells
global FILTER_AMACRINE % Sigma_A value for filtering in Amacrine cells

global GLOBAL_KAPPA % global factor KAPPA to add to the local operation
global GAMMA % gamma power function applied after processing

global filename % filename (or folder name in case of full workflow)

%% Path definition
path(path,'images/'); % add the path to your 1-file-images here (for full workflow see below)


%% Set the  parameters
DISPLAY = 0;

FILTER_HORI = 1.5;
FILTER_AMACRINE = 3;

GLOBAL_KAPPA = 1;
GAMMA = 1/0.7;

CAMERA = '350D';

FullWorkflow = 1; % 1: performs full workflow including HDR file creation

%filename = 'memorial.hdr';
filename = 'imHDR8';

%filetype = 'HDR';
filetype = 'HDR_CFA';

%% Create the HDR file
if FullWorkflow == 1
    if not(strcmp(filetype, 'HDR_CFA'))
        fprintf('runHDRCFA.m error: filetype must be HDR_CFA to run the full workflow')
    end
    createHDR;
    fprintf('HDR file saved to directory \n')
end

%% Call the main function to run the algorithm mainHDR_CFA('filename or folder name for HDR_CFA','filetype')
mainHDR_CFA(filename,filetype);
fprintf('Done \n')



