function Out = postProcessing(In,camera,Tmin,Tmax,gamma)
% function Out = postProcessing(In,camera,Tmin,Tmax,gamma)
% performs the post processing steps on the tone-mapped, demosaiced image
%
% IN:
%   In: image
%   camera: '350D', 'none' and 'unknown' are supported
%   Tmin: threshold min for hist clipping. (e.g. 0.01)
%   Tmax: threshold max for hist clipping. (e.g. 0.995)
%   gamma: gamma value for gamma correction (e.g. 1.25)

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: December 19, 2007, by Daniel Tamburrino

%% Apply color correction from camera RGB to sRGB
% note that the sRGB value might need to be clipped or compressed
switch upper(camera)
    case '350D'
        In=cc(In,camera);
    otherwise
        fprintf(' *******\n No color correction was performed\n *******\n')
end

%% Do luminance histo streching and global gamma correction
In=rgb2ycbcr(In);
Y=In(:,:,1); %Luminance channel

% find low and high values
low_high = stretchlim(Y, [Tmin Tmax]);
newMax = low_high(2);
newMin = low_high(1);

% do correction
Y = imadjust(Y,[newMin; newMax],[16/255 ; 235/255],gamma); % see matlab help to know why 16/255 and 235/255
In(:,:,1)=Y;
Out=ycbcr2rgb(In);