function M = getM(illuminant,camera)
% function M = getM(illuminant,camera)
% 
% Function that returns the color correction matrix from
% a specific camera RGBs to XYZ under the specified illuminant
%
% Example: M = getM('D65','350D')

%% -----------------------------------------------------------------------
% Digital Camera Workflow for HDR images using a model of retinal
% processing
% Written by Daniel Tamburrino, David Alleysson and Laurence Meylan
% Copyright (C) 2007-2008 Laboratory of Audiovisual Communications (LCAV), 
% Ecole Polytechnique Federale de Lausanne (EPFL), 
% CH-1015 Lausanne, Switzerland 
% 
% This program is free software; you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the 
% Free Software Foundation; either version 2 of the License, or (at your 
% option) any later version. This software is distributed in the hope that 
% it will be useful, but without any warranty; without even the implied 
% warranty of merchantability or fitness for a particular purpose. 
% See the GNU General Public License for more details 
% (enclosed in the file GPL). 
%
% Latest modifications: December 19, 2007, by Daniel Tamburrino

% load color correction matrix M from Quantum Efficiency balanced camera
% sensitivity curves to xyz 31 2 degree observer curves
switch upper(camera)
    case '350D'
        load M_350D.mat %load matrix M
    otherwise
        error('getM: unknown camera')
end

% Determine XYZ white point value under illuminant E
E=whitepoint(illuminant);
E=diag(E);

% XYZ_E = E*M*RGB_WB
% RGB_WB = (1 1 1) will be mapped to XYZ under specified illuminant value
M=E*M;
